package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.GroupKind;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ApplicationSpecFluent<A extends ApplicationSpecFluent<A>> extends BaseFluent<A>{
  public ApplicationSpecFluent() {
  }
  
  public ApplicationSpecFluent(ApplicationSpec instance) {
    this.copyInstance(instance);
  }
  private Boolean addOwnerRef;
  private String assemblyPhase;
  private List<GroupKind> componentKinds = new ArrayList<GroupKind>();
  private DescriptorBuilder descriptor;
  private ArrayList<InfoItemBuilder> info = new ArrayList<InfoItemBuilder>();
  private LabelSelectorBuilder selector;
  
  protected void copyInstance(ApplicationSpec instance) {
    instance = (instance != null ? instance : new ApplicationSpec());
    if (instance != null) {
          this.withAddOwnerRef(instance.getAddOwnerRef());
          this.withAssemblyPhase(instance.getAssemblyPhase());
          this.withComponentKinds(instance.getComponentKinds());
          this.withDescriptor(instance.getDescriptor());
          this.withInfo(instance.getInfo());
          this.withSelector(instance.getSelector());
          this.withAddOwnerRef(instance.getAddOwnerRef());
          this.withAssemblyPhase(instance.getAssemblyPhase());
          this.withComponentKinds(instance.getComponentKinds());
          this.withDescriptor(instance.getDescriptor());
          this.withInfo(instance.getInfo());
          this.withSelector(instance.getSelector());
        }
  }
  
  public Boolean getAddOwnerRef() {
    return this.addOwnerRef;
  }
  
  public A withAddOwnerRef(Boolean addOwnerRef) {
    this.addOwnerRef = addOwnerRef;
    return (A) this;
  }
  
  public boolean hasAddOwnerRef() {
    return this.addOwnerRef != null;
  }
  
  public String getAssemblyPhase() {
    return this.assemblyPhase;
  }
  
  public A withAssemblyPhase(String assemblyPhase) {
    this.assemblyPhase = assemblyPhase;
    return (A) this;
  }
  
  public boolean hasAssemblyPhase() {
    return this.assemblyPhase != null;
  }
  
  public A addToComponentKinds(int index,GroupKind item) {
    if (this.componentKinds == null) {this.componentKinds = new ArrayList<GroupKind>();}
    this.componentKinds.add(index, item);
    return (A)this;
  }
  
  public A setToComponentKinds(int index,GroupKind item) {
    if (this.componentKinds == null) {this.componentKinds = new ArrayList<GroupKind>();}
    this.componentKinds.set(index, item); return (A)this;
  }
  
  public A addToComponentKinds(io.fabric8.kubernetes.api.model.GroupKind... items) {
    if (this.componentKinds == null) {this.componentKinds = new ArrayList<GroupKind>();}
    for (GroupKind item : items) {this.componentKinds.add(item);} return (A)this;
  }
  
  public A addAllToComponentKinds(Collection<GroupKind> items) {
    if (this.componentKinds == null) {this.componentKinds = new ArrayList<GroupKind>();}
    for (GroupKind item : items) {this.componentKinds.add(item);} return (A)this;
  }
  
  public A removeFromComponentKinds(io.fabric8.kubernetes.api.model.GroupKind... items) {
    if (this.componentKinds == null) return (A)this;
    for (GroupKind item : items) { this.componentKinds.remove(item);} return (A)this;
  }
  
  public A removeAllFromComponentKinds(Collection<GroupKind> items) {
    if (this.componentKinds == null) return (A)this;
    for (GroupKind item : items) { this.componentKinds.remove(item);} return (A)this;
  }
  
  public List<GroupKind> getComponentKinds() {
    return this.componentKinds;
  }
  
  public GroupKind getComponentKind(int index) {
    return this.componentKinds.get(index);
  }
  
  public GroupKind getFirstComponentKind() {
    return this.componentKinds.get(0);
  }
  
  public GroupKind getLastComponentKind() {
    return this.componentKinds.get(componentKinds.size() - 1);
  }
  
  public GroupKind getMatchingComponentKind(Predicate<GroupKind> predicate) {
      for (GroupKind item : componentKinds) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingComponentKind(Predicate<GroupKind> predicate) {
      for (GroupKind item : componentKinds) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withComponentKinds(List<GroupKind> componentKinds) {
    if (componentKinds != null) {
        this.componentKinds = new ArrayList();
        for (GroupKind item : componentKinds) {
          this.addToComponentKinds(item);
        }
    } else {
      this.componentKinds = null;
    }
    return (A) this;
  }
  
  public A withComponentKinds(io.fabric8.kubernetes.api.model.GroupKind... componentKinds) {
    if (this.componentKinds != null) {this.componentKinds.clear(); _visitables.remove("componentKinds"); }
    if (componentKinds != null) {for (GroupKind item :componentKinds){ this.addToComponentKinds(item);}} return (A) this;
  }
  
  public boolean hasComponentKinds() {
    return this.componentKinds != null && !this.componentKinds.isEmpty();
  }
  
  public A addNewComponentKind(String group,String kind) {
    return (A)addToComponentKinds(new GroupKind(group, kind));
  }
  
  public Descriptor buildDescriptor() {
    return this.descriptor != null ? this.descriptor.build() : null;
  }
  
  public A withDescriptor(Descriptor descriptor) {
    this._visitables.remove(this.descriptor);
    if (descriptor != null) {
        this.descriptor = new DescriptorBuilder(descriptor);
        this._visitables.get("descriptor").add(this.descriptor);
    } else {
        this.descriptor = null;
        this._visitables.get("descriptor").remove(this.descriptor);
    }
    return (A) this;
  }
  
  public boolean hasDescriptor() {
    return this.descriptor != null;
  }
  
  public DescriptorNested<A> withNewDescriptor() {
    return new DescriptorNested(null);
  }
  
  public DescriptorNested<A> withNewDescriptorLike(Descriptor item) {
    return new DescriptorNested(item);
  }
  
  public DescriptorNested<A> editDescriptor() {
    return withNewDescriptorLike(java.util.Optional.ofNullable(buildDescriptor()).orElse(null));
  }
  
  public DescriptorNested<A> editOrNewDescriptor() {
    return withNewDescriptorLike(java.util.Optional.ofNullable(buildDescriptor()).orElse(new DescriptorBuilder().build()));
  }
  
  public DescriptorNested<A> editOrNewDescriptorLike(Descriptor item) {
    return withNewDescriptorLike(java.util.Optional.ofNullable(buildDescriptor()).orElse(item));
  }
  
  public A addToInfo(int index,InfoItem item) {
    if (this.info == null) {this.info = new ArrayList<InfoItemBuilder>();}
    InfoItemBuilder builder = new InfoItemBuilder(item);
    if (index < 0 || index >= info.size()) { _visitables.get("info").add(builder); info.add(builder); } else { _visitables.get("info").add(index, builder); info.add(index, builder);}
    return (A)this;
  }
  
  public A setToInfo(int index,InfoItem item) {
    if (this.info == null) {this.info = new ArrayList<InfoItemBuilder>();}
    InfoItemBuilder builder = new InfoItemBuilder(item);
    if (index < 0 || index >= info.size()) { _visitables.get("info").add(builder); info.add(builder); } else { _visitables.get("info").set(index, builder); info.set(index, builder);}
    return (A)this;
  }
  
  public A addToInfo(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem... items) {
    if (this.info == null) {this.info = new ArrayList<InfoItemBuilder>();}
    for (InfoItem item : items) {InfoItemBuilder builder = new InfoItemBuilder(item);_visitables.get("info").add(builder);this.info.add(builder);} return (A)this;
  }
  
  public A addAllToInfo(Collection<InfoItem> items) {
    if (this.info == null) {this.info = new ArrayList<InfoItemBuilder>();}
    for (InfoItem item : items) {InfoItemBuilder builder = new InfoItemBuilder(item);_visitables.get("info").add(builder);this.info.add(builder);} return (A)this;
  }
  
  public A removeFromInfo(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem... items) {
    if (this.info == null) return (A)this;
    for (InfoItem item : items) {InfoItemBuilder builder = new InfoItemBuilder(item);_visitables.get("info").remove(builder); this.info.remove(builder);} return (A)this;
  }
  
  public A removeAllFromInfo(Collection<InfoItem> items) {
    if (this.info == null) return (A)this;
    for (InfoItem item : items) {InfoItemBuilder builder = new InfoItemBuilder(item);_visitables.get("info").remove(builder); this.info.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromInfo(Predicate<InfoItemBuilder> predicate) {
    if (info == null) return (A) this;
    final Iterator<InfoItemBuilder> each = info.iterator();
    final List visitables = _visitables.get("info");
    while (each.hasNext()) {
      InfoItemBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<InfoItem> buildInfo() {
    return this.info != null ? build(info) : null;
  }
  
  public InfoItem buildInfo(int index) {
    return this.info.get(index).build();
  }
  
  public InfoItem buildFirstInfo() {
    return this.info.get(0).build();
  }
  
  public InfoItem buildLastInfo() {
    return this.info.get(info.size() - 1).build();
  }
  
  public InfoItem buildMatchingInfo(Predicate<InfoItemBuilder> predicate) {
      for (InfoItemBuilder item : info) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingInfo(Predicate<InfoItemBuilder> predicate) {
      for (InfoItemBuilder item : info) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withInfo(List<InfoItem> info) {
    if (this.info != null) {
      this._visitables.get("info").clear();
    }
    if (info != null) {
        this.info = new ArrayList();
        for (InfoItem item : info) {
          this.addToInfo(item);
        }
    } else {
      this.info = null;
    }
    return (A) this;
  }
  
  public A withInfo(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem... info) {
    if (this.info != null) {this.info.clear(); _visitables.remove("info"); }
    if (info != null) {for (InfoItem item :info){ this.addToInfo(item);}} return (A) this;
  }
  
  public boolean hasInfo() {
    return this.info != null && !this.info.isEmpty();
  }
  
  public InfoNested<A> addNewInfo() {
    return new InfoNested(-1, null);
  }
  
  public InfoNested<A> addNewInfoLike(InfoItem item) {
    return new InfoNested(-1, item);
  }
  
  public InfoNested<A> setNewInfoLike(int index,InfoItem item) {
    return new InfoNested(index, item);
  }
  
  public InfoNested<A> editInfo(int index) {
    if (info.size() <= index) throw new RuntimeException("Can't edit info. Index exceeds size.");
    return setNewInfoLike(index, buildInfo(index));
  }
  
  public InfoNested<A> editFirstInfo() {
    if (info.size() == 0) throw new RuntimeException("Can't edit first info. The list is empty.");
    return setNewInfoLike(0, buildInfo(0));
  }
  
  public InfoNested<A> editLastInfo() {
    int index = info.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last info. The list is empty.");
    return setNewInfoLike(index, buildInfo(index));
  }
  
  public InfoNested<A> editMatchingInfo(Predicate<InfoItemBuilder> predicate) {
    int index = -1;
    for (int i=0;i<info.size();i++) { 
    if (predicate.test(info.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching info. No match found.");
    return setNewInfoLike(index, buildInfo(index));
  }
  
  public LabelSelector buildSelector() {
    return this.selector != null ? this.selector.build() : null;
  }
  
  public A withSelector(LabelSelector selector) {
    this._visitables.remove(this.selector);
    if (selector != null) {
        this.selector = new LabelSelectorBuilder(selector);
        this._visitables.get("selector").add(this.selector);
    } else {
        this.selector = null;
        this._visitables.get("selector").remove(this.selector);
    }
    return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ApplicationSpecFluent that = (ApplicationSpecFluent) o;
    if (!java.util.Objects.equals(addOwnerRef, that.addOwnerRef)) return false;
    if (!java.util.Objects.equals(assemblyPhase, that.assemblyPhase)) return false;
    if (!java.util.Objects.equals(componentKinds, that.componentKinds)) return false;
    if (!java.util.Objects.equals(descriptor, that.descriptor)) return false;
    if (!java.util.Objects.equals(info, that.info)) return false;
    if (!java.util.Objects.equals(selector, that.selector)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(addOwnerRef,  assemblyPhase,  componentKinds,  descriptor,  info,  selector,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (addOwnerRef != null) { sb.append("addOwnerRef:"); sb.append(addOwnerRef + ","); }
    if (assemblyPhase != null) { sb.append("assemblyPhase:"); sb.append(assemblyPhase + ","); }
    if (componentKinds != null && !componentKinds.isEmpty()) { sb.append("componentKinds:"); sb.append(componentKinds + ","); }
    if (descriptor != null) { sb.append("descriptor:"); sb.append(descriptor + ","); }
    if (info != null && !info.isEmpty()) { sb.append("info:"); sb.append(info + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withAddOwnerRef() {
    return withAddOwnerRef(true);
  }
  public class DescriptorNested<N> extends DescriptorFluent<DescriptorNested<N>> implements Nested<N>{
    DescriptorNested(Descriptor item) {
      this.builder = new DescriptorBuilder(this, item);
    }
    DescriptorBuilder builder;
    
    public N and() {
      return (N) ApplicationSpecFluent.this.withDescriptor(builder.build());
    }
    
    public N endDescriptor() {
      return and();
    }
    
  
  }
  public class InfoNested<N> extends InfoItemFluent<InfoNested<N>> implements Nested<N>{
    InfoNested(int index,InfoItem item) {
      this.index = index;
      this.builder = new InfoItemBuilder(this, item);
    }
    InfoItemBuilder builder;
    int index;
    
    public N and() {
      return (N) ApplicationSpecFluent.this.setToInfo(index,builder.build());
    }
    
    public N endInfo() {
      return and();
    }
    
  
  }
  public class SelectorNested<N> extends LabelSelectorFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) ApplicationSpecFluent.this.withSelector(builder.build());
    }
    
    public N endSelector() {
      return and();
    }
    
  
  }

}