package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ApplicationListBuilder extends ApplicationListFluent<ApplicationListBuilder> implements VisitableBuilder<ApplicationList,ApplicationListBuilder>{
  public ApplicationListBuilder() {
    this(new ApplicationList());
  }
  
  public ApplicationListBuilder(ApplicationListFluent<?> fluent) {
    this(fluent, new ApplicationList());
  }
  
  public ApplicationListBuilder(ApplicationListFluent<?> fluent,ApplicationList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ApplicationListBuilder(ApplicationList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ApplicationListFluent<?> fluent;
  
  public ApplicationList build() {
    ApplicationList buildable = new ApplicationList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  

}