package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ApplicationBuilder extends ApplicationFluent<ApplicationBuilder> implements VisitableBuilder<Application,ApplicationBuilder>{
  public ApplicationBuilder() {
    this(new Application());
  }
  
  public ApplicationBuilder(ApplicationFluent<?> fluent) {
    this(fluent, new Application());
  }
  
  public ApplicationBuilder(ApplicationFluent<?> fluent,Application instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ApplicationBuilder(Application instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ApplicationFluent<?> fluent;
  
  public Application build() {
    Application buildable = new Application(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}