/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1.ChannelGate;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1.ChannelGateBuilder;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1.ChannelGateFluent;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1.ChannelSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ChannelSpecFluent<A extends ChannelSpecFluent<A>>
extends BaseFluent<A> {
    private ObjectReferenceBuilder configMapRef;
    private ChannelGateBuilder gates;
    private Boolean insecureSkipVerify;
    private String pathname;
    private ObjectReferenceBuilder secretRef;
    private List<String> sourceNamespaces = new ArrayList<String>();
    private String type;

    public ChannelSpecFluent() {
    }

    public ChannelSpecFluent(ChannelSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ChannelSpec instance) {
        ChannelSpec channelSpec = instance = instance != null ? instance : new ChannelSpec();
        if (instance != null) {
            this.withConfigMapRef(instance.getConfigMapRef());
            this.withGates(instance.getGates());
            this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
            this.withPathname(instance.getPathname());
            this.withSecretRef(instance.getSecretRef());
            this.withSourceNamespaces(instance.getSourceNamespaces());
            this.withType(instance.getType());
            this.withConfigMapRef(instance.getConfigMapRef());
            this.withGates(instance.getGates());
            this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
            this.withPathname(instance.getPathname());
            this.withSecretRef(instance.getSecretRef());
            this.withSourceNamespaces(instance.getSourceNamespaces());
            this.withType(instance.getType());
        }
    }

    public ObjectReference buildConfigMapRef() {
        return this.configMapRef != null ? this.configMapRef.build() : null;
    }

    public A withConfigMapRef(ObjectReference configMapRef) {
        this._visitables.get((Object)"configMapRef").remove(this.configMapRef);
        if (configMapRef != null) {
            this.configMapRef = new ObjectReferenceBuilder(configMapRef);
            this._visitables.get((Object)"configMapRef").add(this.configMapRef);
        } else {
            this.configMapRef = null;
            this._visitables.get((Object)"configMapRef").remove(this.configMapRef);
        }
        return (A)((Object)this);
    }

    public boolean hasConfigMapRef() {
        return this.configMapRef != null;
    }

    public ConfigMapRefNested<A> withNewConfigMapRef() {
        return new ConfigMapRefNested(null);
    }

    public ConfigMapRefNested<A> withNewConfigMapRefLike(ObjectReference item) {
        return new ConfigMapRefNested(item);
    }

    public ConfigMapRefNested<A> editConfigMapRef() {
        return this.withNewConfigMapRefLike(Optional.ofNullable(this.buildConfigMapRef()).orElse(null));
    }

    public ConfigMapRefNested<A> editOrNewConfigMapRef() {
        return this.withNewConfigMapRefLike(Optional.ofNullable(this.buildConfigMapRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public ConfigMapRefNested<A> editOrNewConfigMapRefLike(ObjectReference item) {
        return this.withNewConfigMapRefLike(Optional.ofNullable(this.buildConfigMapRef()).orElse(item));
    }

    public ChannelGate buildGates() {
        return this.gates != null ? this.gates.build() : null;
    }

    public A withGates(ChannelGate gates) {
        this._visitables.get((Object)"gates").remove((Object)this.gates);
        if (gates != null) {
            this.gates = new ChannelGateBuilder(gates);
            this._visitables.get((Object)"gates").add(this.gates);
        } else {
            this.gates = null;
            this._visitables.get((Object)"gates").remove((Object)this.gates);
        }
        return (A)((Object)this);
    }

    public boolean hasGates() {
        return this.gates != null;
    }

    public GatesNested<A> withNewGates() {
        return new GatesNested(null);
    }

    public GatesNested<A> withNewGatesLike(ChannelGate item) {
        return new GatesNested(item);
    }

    public GatesNested<A> editGates() {
        return this.withNewGatesLike(Optional.ofNullable(this.buildGates()).orElse(null));
    }

    public GatesNested<A> editOrNewGates() {
        return this.withNewGatesLike(Optional.ofNullable(this.buildGates()).orElse(new ChannelGateBuilder().build()));
    }

    public GatesNested<A> editOrNewGatesLike(ChannelGate item) {
        return this.withNewGatesLike(Optional.ofNullable(this.buildGates()).orElse(item));
    }

    public Boolean getInsecureSkipVerify() {
        return this.insecureSkipVerify;
    }

    public A withInsecureSkipVerify(Boolean insecureSkipVerify) {
        this.insecureSkipVerify = insecureSkipVerify;
        return (A)((Object)this);
    }

    public boolean hasInsecureSkipVerify() {
        return this.insecureSkipVerify != null;
    }

    public String getPathname() {
        return this.pathname;
    }

    public A withPathname(String pathname) {
        this.pathname = pathname;
        return (A)((Object)this);
    }

    public boolean hasPathname() {
        return this.pathname != null;
    }

    public ObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    public A withSecretRef(ObjectReference secretRef) {
        this._visitables.get((Object)"secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new ObjectReferenceBuilder(secretRef);
            this._visitables.get((Object)"secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get((Object)"secretRef").remove(this.secretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNested(null);
    }

    public SecretRefNested<A> withNewSecretRefLike(ObjectReference item) {
        return new SecretRefNested(item);
    }

    public SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(null));
    }

    public SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public SecretRefNested<A> editOrNewSecretRefLike(ObjectReference item) {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(item));
    }

    public A addToSourceNamespaces(int index, String item) {
        if (this.sourceNamespaces == null) {
            this.sourceNamespaces = new ArrayList<String>();
        }
        this.sourceNamespaces.add(index, item);
        return (A)((Object)this);
    }

    public A setToSourceNamespaces(int index, String item) {
        if (this.sourceNamespaces == null) {
            this.sourceNamespaces = new ArrayList<String>();
        }
        this.sourceNamespaces.set(index, item);
        return (A)((Object)this);
    }

    public A addToSourceNamespaces(String ... items) {
        if (this.sourceNamespaces == null) {
            this.sourceNamespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.sourceNamespaces.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSourceNamespaces(Collection<String> items) {
        if (this.sourceNamespaces == null) {
            this.sourceNamespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.sourceNamespaces.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSourceNamespaces(String ... items) {
        if (this.sourceNamespaces == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.sourceNamespaces.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSourceNamespaces(Collection<String> items) {
        if (this.sourceNamespaces == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.sourceNamespaces.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getSourceNamespaces() {
        return this.sourceNamespaces;
    }

    public String getSourceNamespace(int index) {
        return this.sourceNamespaces.get(index);
    }

    public String getFirstSourceNamespace() {
        return this.sourceNamespaces.get(0);
    }

    public String getLastSourceNamespace() {
        return this.sourceNamespaces.get(this.sourceNamespaces.size() - 1);
    }

    public String getMatchingSourceNamespace(Predicate<String> predicate) {
        for (String item : this.sourceNamespaces) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSourceNamespace(Predicate<String> predicate) {
        for (String item : this.sourceNamespaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSourceNamespaces(List<String> sourceNamespaces) {
        if (sourceNamespaces != null) {
            this.sourceNamespaces = new ArrayList<String>();
            for (String item : sourceNamespaces) {
                this.addToSourceNamespaces(item);
            }
        } else {
            this.sourceNamespaces = null;
        }
        return (A)((Object)this);
    }

    public A withSourceNamespaces(String ... sourceNamespaces) {
        if (this.sourceNamespaces != null) {
            this.sourceNamespaces.clear();
            this._visitables.remove((Object)"sourceNamespaces");
        }
        if (sourceNamespaces != null) {
            for (String item : sourceNamespaces) {
                this.addToSourceNamespaces(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSourceNamespaces() {
        return this.sourceNamespaces != null && !this.sourceNamespaces.isEmpty();
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChannelSpecFluent that = (ChannelSpecFluent)((Object)o);
        if (!Objects.equals(this.configMapRef, that.configMapRef)) {
            return false;
        }
        if (!Objects.equals((Object)this.gates, (Object)that.gates)) {
            return false;
        }
        if (!Objects.equals(this.insecureSkipVerify, that.insecureSkipVerify)) {
            return false;
        }
        if (!Objects.equals(this.pathname, that.pathname)) {
            return false;
        }
        if (!Objects.equals(this.secretRef, that.secretRef)) {
            return false;
        }
        if (!Objects.equals(this.sourceNamespaces, that.sourceNamespaces)) {
            return false;
        }
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configMapRef, this.gates, this.insecureSkipVerify, this.pathname, this.secretRef, this.sourceNamespaces, this.type, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configMapRef != null) {
            sb.append("configMapRef:");
            sb.append(this.configMapRef + ",");
        }
        if (this.gates != null) {
            sb.append("gates:");
            sb.append((Object)((Object)this.gates) + ",");
        }
        if (this.insecureSkipVerify != null) {
            sb.append("insecureSkipVerify:");
            sb.append(this.insecureSkipVerify + ",");
        }
        if (this.pathname != null) {
            sb.append("pathname:");
            sb.append(this.pathname + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.sourceNamespaces != null && !this.sourceNamespaces.isEmpty()) {
            sb.append("sourceNamespaces:");
            sb.append(this.sourceNamespaces + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withInsecureSkipVerify() {
        return this.withInsecureSkipVerify(true);
    }

    public class SecretRefNested<N>
    extends ObjectReferenceFluent<SecretRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        SecretRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)ChannelSpecFluent.this.withSecretRef(this.builder.build());
        }

        public N endSecretRef() {
            return this.and();
        }
    }

    public class GatesNested<N>
    extends ChannelGateFluent<GatesNested<N>>
    implements Nested<N> {
        ChannelGateBuilder builder;

        GatesNested(ChannelGate item) {
            this.builder = new ChannelGateBuilder(this, item);
        }

        public N and() {
            return (N)ChannelSpecFluent.this.withGates(this.builder.build());
        }

        public N endGates() {
            return this.and();
        }
    }

    public class ConfigMapRefNested<N>
    extends ObjectReferenceFluent<ConfigMapRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        ConfigMapRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)ChannelSpecFluent.this.withConfigMapRef(this.builder.build());
        }

        public N endConfigMapRef() {
            return this.and();
        }
    }
}

