/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.HourRange;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.HourRangeBuilder;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.HourRangeFluentImpl;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.TimeWindow;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.TimeWindowFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class TimeWindowFluentImpl<A extends TimeWindowFluent<A>>
extends BaseFluent<A>
implements TimeWindowFluent<A> {
    private List<String> daysofweek = new ArrayList<String>();
    private ArrayList<HourRangeBuilder> hours = new ArrayList();
    private String location;
    private String windowtype;

    public TimeWindowFluentImpl() {
    }

    public TimeWindowFluentImpl(TimeWindow instance) {
        if (instance != null) {
            this.withDaysofweek(instance.getDaysofweek());
            this.withHours(instance.getHours());
            this.withLocation(instance.getLocation());
            this.withWindowtype(instance.getWindowtype());
        }
    }

    @Override
    public A addToDaysofweek(int index, String item) {
        if (this.daysofweek == null) {
            this.daysofweek = new ArrayList<String>();
        }
        this.daysofweek.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDaysofweek(int index, String item) {
        if (this.daysofweek == null) {
            this.daysofweek = new ArrayList<String>();
        }
        this.daysofweek.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDaysofweek(String ... items) {
        if (this.daysofweek == null) {
            this.daysofweek = new ArrayList<String>();
        }
        for (String item : items) {
            this.daysofweek.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDaysofweek(Collection<String> items) {
        if (this.daysofweek == null) {
            this.daysofweek = new ArrayList<String>();
        }
        for (String item : items) {
            this.daysofweek.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDaysofweek(String ... items) {
        for (String item : items) {
            if (this.daysofweek == null) continue;
            this.daysofweek.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDaysofweek(Collection<String> items) {
        for (String item : items) {
            if (this.daysofweek == null) continue;
            this.daysofweek.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDaysofweek() {
        return this.daysofweek;
    }

    @Override
    public String getDaysofweek(int index) {
        return this.daysofweek.get(index);
    }

    @Override
    public String getFirstDaysofweek() {
        return this.daysofweek.get(0);
    }

    @Override
    public String getLastDaysofweek() {
        return this.daysofweek.get(this.daysofweek.size() - 1);
    }

    @Override
    public String getMatchingDaysofweek(Predicate<String> predicate) {
        for (String item : this.daysofweek) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDaysofweek(Predicate<String> predicate) {
        for (String item : this.daysofweek) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDaysofweek(List<String> daysofweek) {
        if (daysofweek != null) {
            this.daysofweek = new ArrayList<String>();
            for (String item : daysofweek) {
                this.addToDaysofweek(item);
            }
        } else {
            this.daysofweek = null;
        }
        return (A)this;
    }

    @Override
    public A withDaysofweek(String ... daysofweek) {
        if (this.daysofweek != null) {
            this.daysofweek.clear();
            this._visitables.remove((Object)"daysofweek");
        }
        if (daysofweek != null) {
            for (String item : daysofweek) {
                this.addToDaysofweek(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDaysofweek() {
        return this.daysofweek != null && !this.daysofweek.isEmpty();
    }

    @Override
    public A addToHours(int index, HourRange item) {
        if (this.hours == null) {
            this.hours = new ArrayList();
        }
        HourRangeBuilder builder = new HourRangeBuilder(item);
        if (index < 0 || index >= this.hours.size()) {
            this._visitables.get((Object)"hours").add(builder);
            this.hours.add(builder);
        } else {
            this._visitables.get((Object)"hours").add(index, builder);
            this.hours.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToHours(int index, HourRange item) {
        if (this.hours == null) {
            this.hours = new ArrayList();
        }
        HourRangeBuilder builder = new HourRangeBuilder(item);
        if (index < 0 || index >= this.hours.size()) {
            this._visitables.get((Object)"hours").add(builder);
            this.hours.add(builder);
        } else {
            this._visitables.get((Object)"hours").set(index, builder);
            this.hours.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHours(HourRange ... items) {
        if (this.hours == null) {
            this.hours = new ArrayList();
        }
        for (HourRange item : items) {
            HourRangeBuilder builder = new HourRangeBuilder(item);
            this._visitables.get((Object)"hours").add(builder);
            this.hours.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHours(Collection<HourRange> items) {
        if (this.hours == null) {
            this.hours = new ArrayList();
        }
        for (HourRange item : items) {
            HourRangeBuilder builder = new HourRangeBuilder(item);
            this._visitables.get((Object)"hours").add(builder);
            this.hours.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHours(HourRange ... items) {
        for (HourRange item : items) {
            HourRangeBuilder builder = new HourRangeBuilder(item);
            this._visitables.get((Object)"hours").remove(builder);
            if (this.hours == null) continue;
            this.hours.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHours(Collection<HourRange> items) {
        for (HourRange item : items) {
            HourRangeBuilder builder = new HourRangeBuilder(item);
            this._visitables.get((Object)"hours").remove(builder);
            if (this.hours == null) continue;
            this.hours.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromHours(Predicate<HourRangeBuilder> predicate) {
        if (this.hours == null) {
            return (A)this;
        }
        Iterator<HourRangeBuilder> each = this.hours.iterator();
        List visitables = this._visitables.get((Object)"hours");
        while (each.hasNext()) {
            HourRangeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HourRange> getHours() {
        return this.hours != null ? TimeWindowFluentImpl.build(this.hours) : null;
    }

    @Override
    public List<HourRange> buildHours() {
        return this.hours != null ? TimeWindowFluentImpl.build(this.hours) : null;
    }

    @Override
    public HourRange buildHour(int index) {
        return this.hours.get(index).build();
    }

    @Override
    public HourRange buildFirstHour() {
        return this.hours.get(0).build();
    }

    @Override
    public HourRange buildLastHour() {
        return this.hours.get(this.hours.size() - 1).build();
    }

    @Override
    public HourRange buildMatchingHour(Predicate<HourRangeBuilder> predicate) {
        for (HourRangeBuilder item : this.hours) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHour(Predicate<HourRangeBuilder> predicate) {
        for (HourRangeBuilder item : this.hours) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHours(List<HourRange> hours) {
        if (this.hours != null) {
            this._visitables.get((Object)"hours").clear();
        }
        if (hours != null) {
            this.hours = new ArrayList();
            for (HourRange item : hours) {
                this.addToHours(item);
            }
        } else {
            this.hours = null;
        }
        return (A)this;
    }

    @Override
    public A withHours(HourRange ... hours) {
        if (this.hours != null) {
            this.hours.clear();
            this._visitables.remove((Object)"hours");
        }
        if (hours != null) {
            for (HourRange item : hours) {
                this.addToHours(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHours() {
        return this.hours != null && !this.hours.isEmpty();
    }

    @Override
    public A addNewHour(String end, String start) {
        return this.addToHours(new HourRange(end, start));
    }

    @Override
    public TimeWindowFluent.HoursNested<A> addNewHour() {
        return new HoursNestedImpl();
    }

    @Override
    public TimeWindowFluent.HoursNested<A> addNewHourLike(HourRange item) {
        return new HoursNestedImpl(-1, item);
    }

    @Override
    public TimeWindowFluent.HoursNested<A> setNewHourLike(int index, HourRange item) {
        return new HoursNestedImpl(index, item);
    }

    @Override
    public TimeWindowFluent.HoursNested<A> editHour(int index) {
        if (this.hours.size() <= index) {
            throw new RuntimeException("Can't edit hours. Index exceeds size.");
        }
        return this.setNewHourLike(index, this.buildHour(index));
    }

    @Override
    public TimeWindowFluent.HoursNested<A> editFirstHour() {
        if (this.hours.size() == 0) {
            throw new RuntimeException("Can't edit first hours. The list is empty.");
        }
        return this.setNewHourLike(0, this.buildHour(0));
    }

    @Override
    public TimeWindowFluent.HoursNested<A> editLastHour() {
        int index = this.hours.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last hours. The list is empty.");
        }
        return this.setNewHourLike(index, this.buildHour(index));
    }

    @Override
    public TimeWindowFluent.HoursNested<A> editMatchingHour(Predicate<HourRangeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.hours.size(); ++i) {
            if (!predicate.test(this.hours.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching hours. No match found.");
        }
        return this.setNewHourLike(index, this.buildHour(index));
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public A withLocation(String location) {
        this.location = location;
        return (A)this;
    }

    @Override
    public Boolean hasLocation() {
        return this.location != null;
    }

    @Override
    public String getWindowtype() {
        return this.windowtype;
    }

    @Override
    public A withWindowtype(String windowtype) {
        this.windowtype = windowtype;
        return (A)this;
    }

    @Override
    public Boolean hasWindowtype() {
        return this.windowtype != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeWindowFluentImpl that = (TimeWindowFluentImpl)o;
        if (!Objects.equals(this.daysofweek, that.daysofweek)) {
            return false;
        }
        if (!Objects.equals(this.hours, that.hours)) {
            return false;
        }
        if (!Objects.equals(this.location, that.location)) {
            return false;
        }
        return Objects.equals(this.windowtype, that.windowtype);
    }

    public int hashCode() {
        return Objects.hash(this.daysofweek, this.hours, this.location, this.windowtype, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.daysofweek != null && !this.daysofweek.isEmpty()) {
            sb.append("daysofweek:");
            sb.append(this.daysofweek + ",");
        }
        if (this.hours != null) {
            sb.append("hours:");
            sb.append(this.hours + ",");
        }
        if (this.location != null) {
            sb.append("location:");
            sb.append(this.location + ",");
        }
        if (this.windowtype != null) {
            sb.append("windowtype:");
            sb.append(this.windowtype);
        }
        sb.append("}");
        return sb.toString();
    }

    class HoursNestedImpl<N>
    extends HourRangeFluentImpl<TimeWindowFluent.HoursNested<N>>
    implements TimeWindowFluent.HoursNested<N>,
    Nested<N> {
        HourRangeBuilder builder;
        int index;

        HoursNestedImpl(int index, HourRange item) {
            this.index = index;
            this.builder = new HourRangeBuilder(this, item);
        }

        HoursNestedImpl() {
            this.index = -1;
            this.builder = new HourRangeBuilder(this);
        }

        @Override
        public N and() {
            return (N)TimeWindowFluentImpl.this.setToHours(this.index, this.builder.build());
        }

        @Override
        public N endHour() {
            return this.and();
        }
    }
}

