/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1.ChannelGate;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1.ChannelGateBuilder;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1.ChannelGateFluentImpl;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1.ChannelSpec;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1.ChannelSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ChannelSpecFluentImpl<A extends ChannelSpecFluent<A>>
extends BaseFluent<A>
implements ChannelSpecFluent<A> {
    private ObjectReferenceBuilder configMapRef;
    private ChannelGateBuilder gates;
    private Boolean insecureSkipVerify;
    private String pathname;
    private ObjectReferenceBuilder secretRef;
    private List<String> sourceNamespaces = new ArrayList<String>();
    private String type;

    public ChannelSpecFluentImpl() {
    }

    public ChannelSpecFluentImpl(ChannelSpec instance) {
        if (instance != null) {
            this.withConfigMapRef(instance.getConfigMapRef());
            this.withGates(instance.getGates());
            this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
            this.withPathname(instance.getPathname());
            this.withSecretRef(instance.getSecretRef());
            this.withSourceNamespaces(instance.getSourceNamespaces());
            this.withType(instance.getType());
        }
    }

    @Override
    @Deprecated
    public ObjectReference getConfigMapRef() {
        return this.configMapRef != null ? this.configMapRef.build() : null;
    }

    @Override
    public ObjectReference buildConfigMapRef() {
        return this.configMapRef != null ? this.configMapRef.build() : null;
    }

    @Override
    public A withConfigMapRef(ObjectReference configMapRef) {
        this._visitables.get((Object)"configMapRef").remove(this.configMapRef);
        if (configMapRef != null) {
            this.configMapRef = new ObjectReferenceBuilder(configMapRef);
            this._visitables.get((Object)"configMapRef").add(this.configMapRef);
        } else {
            this.configMapRef = null;
            this._visitables.get((Object)"configMapRef").remove(this.configMapRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfigMapRef() {
        return this.configMapRef != null;
    }

    @Override
    public ChannelSpecFluent.ConfigMapRefNested<A> withNewConfigMapRef() {
        return new ConfigMapRefNestedImpl();
    }

    @Override
    public ChannelSpecFluent.ConfigMapRefNested<A> withNewConfigMapRefLike(ObjectReference item) {
        return new ConfigMapRefNestedImpl(item);
    }

    @Override
    public ChannelSpecFluent.ConfigMapRefNested<A> editConfigMapRef() {
        return this.withNewConfigMapRefLike(this.getConfigMapRef());
    }

    @Override
    public ChannelSpecFluent.ConfigMapRefNested<A> editOrNewConfigMapRef() {
        return this.withNewConfigMapRefLike(this.getConfigMapRef() != null ? this.getConfigMapRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public ChannelSpecFluent.ConfigMapRefNested<A> editOrNewConfigMapRefLike(ObjectReference item) {
        return this.withNewConfigMapRefLike(this.getConfigMapRef() != null ? this.getConfigMapRef() : item);
    }

    @Override
    @Deprecated
    public ChannelGate getGates() {
        return this.gates != null ? this.gates.build() : null;
    }

    @Override
    public ChannelGate buildGates() {
        return this.gates != null ? this.gates.build() : null;
    }

    @Override
    public A withGates(ChannelGate gates) {
        this._visitables.get((Object)"gates").remove(this.gates);
        if (gates != null) {
            this.gates = new ChannelGateBuilder(gates);
            this._visitables.get((Object)"gates").add(this.gates);
        } else {
            this.gates = null;
            this._visitables.get((Object)"gates").remove(this.gates);
        }
        return (A)this;
    }

    @Override
    public Boolean hasGates() {
        return this.gates != null;
    }

    @Override
    public ChannelSpecFluent.GatesNested<A> withNewGates() {
        return new GatesNestedImpl();
    }

    @Override
    public ChannelSpecFluent.GatesNested<A> withNewGatesLike(ChannelGate item) {
        return new GatesNestedImpl(item);
    }

    @Override
    public ChannelSpecFluent.GatesNested<A> editGates() {
        return this.withNewGatesLike(this.getGates());
    }

    @Override
    public ChannelSpecFluent.GatesNested<A> editOrNewGates() {
        return this.withNewGatesLike(this.getGates() != null ? this.getGates() : new ChannelGateBuilder().build());
    }

    @Override
    public ChannelSpecFluent.GatesNested<A> editOrNewGatesLike(ChannelGate item) {
        return this.withNewGatesLike(this.getGates() != null ? this.getGates() : item);
    }

    @Override
    public Boolean getInsecureSkipVerify() {
        return this.insecureSkipVerify;
    }

    @Override
    public A withInsecureSkipVerify(Boolean insecureSkipVerify) {
        this.insecureSkipVerify = insecureSkipVerify;
        return (A)this;
    }

    @Override
    public Boolean hasInsecureSkipVerify() {
        return this.insecureSkipVerify != null;
    }

    @Override
    public String getPathname() {
        return this.pathname;
    }

    @Override
    public A withPathname(String pathname) {
        this.pathname = pathname;
        return (A)this;
    }

    @Override
    public Boolean hasPathname() {
        return this.pathname != null;
    }

    @Override
    @Deprecated
    public ObjectReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public ObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(ObjectReference secretRef) {
        this._visitables.get((Object)"secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new ObjectReferenceBuilder(secretRef);
            this._visitables.get((Object)"secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get((Object)"secretRef").remove(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public ChannelSpecFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public ChannelSpecFluent.SecretRefNested<A> withNewSecretRefLike(ObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public ChannelSpecFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public ChannelSpecFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public ChannelSpecFluent.SecretRefNested<A> editOrNewSecretRefLike(ObjectReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public A addToSourceNamespaces(int index, String item) {
        if (this.sourceNamespaces == null) {
            this.sourceNamespaces = new ArrayList<String>();
        }
        this.sourceNamespaces.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSourceNamespaces(int index, String item) {
        if (this.sourceNamespaces == null) {
            this.sourceNamespaces = new ArrayList<String>();
        }
        this.sourceNamespaces.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSourceNamespaces(String ... items) {
        if (this.sourceNamespaces == null) {
            this.sourceNamespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.sourceNamespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSourceNamespaces(Collection<String> items) {
        if (this.sourceNamespaces == null) {
            this.sourceNamespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.sourceNamespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSourceNamespaces(String ... items) {
        for (String item : items) {
            if (this.sourceNamespaces == null) continue;
            this.sourceNamespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSourceNamespaces(Collection<String> items) {
        for (String item : items) {
            if (this.sourceNamespaces == null) continue;
            this.sourceNamespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSourceNamespaces() {
        return this.sourceNamespaces;
    }

    @Override
    public String getSourceNamespace(int index) {
        return this.sourceNamespaces.get(index);
    }

    @Override
    public String getFirstSourceNamespace() {
        return this.sourceNamespaces.get(0);
    }

    @Override
    public String getLastSourceNamespace() {
        return this.sourceNamespaces.get(this.sourceNamespaces.size() - 1);
    }

    @Override
    public String getMatchingSourceNamespace(Predicate<String> predicate) {
        for (String item : this.sourceNamespaces) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSourceNamespace(Predicate<String> predicate) {
        for (String item : this.sourceNamespaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSourceNamespaces(List<String> sourceNamespaces) {
        if (sourceNamespaces != null) {
            this.sourceNamespaces = new ArrayList<String>();
            for (String item : sourceNamespaces) {
                this.addToSourceNamespaces(item);
            }
        } else {
            this.sourceNamespaces = null;
        }
        return (A)this;
    }

    @Override
    public A withSourceNamespaces(String ... sourceNamespaces) {
        if (this.sourceNamespaces != null) {
            this.sourceNamespaces.clear();
            this._visitables.remove((Object)"sourceNamespaces");
        }
        if (sourceNamespaces != null) {
            for (String item : sourceNamespaces) {
                this.addToSourceNamespaces(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSourceNamespaces() {
        return this.sourceNamespaces != null && !this.sourceNamespaces.isEmpty();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChannelSpecFluentImpl that = (ChannelSpecFluentImpl)o;
        if (!Objects.equals(this.configMapRef, that.configMapRef)) {
            return false;
        }
        if (!Objects.equals(this.gates, that.gates)) {
            return false;
        }
        if (!Objects.equals(this.insecureSkipVerify, that.insecureSkipVerify)) {
            return false;
        }
        if (!Objects.equals(this.pathname, that.pathname)) {
            return false;
        }
        if (!Objects.equals(this.secretRef, that.secretRef)) {
            return false;
        }
        if (!Objects.equals(this.sourceNamespaces, that.sourceNamespaces)) {
            return false;
        }
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.configMapRef, this.gates, this.insecureSkipVerify, this.pathname, this.secretRef, this.sourceNamespaces, this.type, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configMapRef != null) {
            sb.append("configMapRef:");
            sb.append(this.configMapRef + ",");
        }
        if (this.gates != null) {
            sb.append("gates:");
            sb.append(this.gates + ",");
        }
        if (this.insecureSkipVerify != null) {
            sb.append("insecureSkipVerify:");
            sb.append(this.insecureSkipVerify + ",");
        }
        if (this.pathname != null) {
            sb.append("pathname:");
            sb.append(this.pathname + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.sourceNamespaces != null && !this.sourceNamespaces.isEmpty()) {
            sb.append("sourceNamespaces:");
            sb.append(this.sourceNamespaces + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withInsecureSkipVerify() {
        return this.withInsecureSkipVerify(true);
    }

    class SecretRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<ChannelSpecFluent.SecretRefNested<N>>
    implements ChannelSpecFluent.SecretRefNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        SecretRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)ChannelSpecFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }

    class GatesNestedImpl<N>
    extends ChannelGateFluentImpl<ChannelSpecFluent.GatesNested<N>>
    implements ChannelSpecFluent.GatesNested<N>,
    Nested<N> {
        ChannelGateBuilder builder;

        GatesNestedImpl(ChannelGate item) {
            this.builder = new ChannelGateBuilder(this, item);
        }

        GatesNestedImpl() {
            this.builder = new ChannelGateBuilder(this);
        }

        @Override
        public N and() {
            return (N)ChannelSpecFluentImpl.this.withGates(this.builder.build());
        }

        @Override
        public N endGates() {
            return this.and();
        }
    }

    class ConfigMapRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<ChannelSpecFluent.ConfigMapRefNested<N>>
    implements ChannelSpecFluent.ConfigMapRefNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        ConfigMapRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        ConfigMapRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)ChannelSpecFluentImpl.this.withConfigMapRef(this.builder.build());
        }

        @Override
        public N endConfigMapRef() {
            return this.and();
        }
    }
}

