package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PackageFilterFluentImpl<A extends PackageFilterFluent<A>> extends BaseFluent<A> implements PackageFilterFluent<A>{
  public PackageFilterFluentImpl() {
  }
  public PackageFilterFluentImpl(PackageFilter instance) {
    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withFilterRef(instance.getFilterRef());
      this.withLabelSelector(instance.getLabelSelector());
      this.withVersion(instance.getVersion());
    }
  }
  private Map<String,String> annotations;
  private LocalObjectReferenceBuilder filterRef;
  private LabelSelectorBuilder labelSelector;
  private String version;
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public Boolean hasAnnotations() {
    return this.annotations != null;
  }
  
  /**
   * This method has been deprecated, please use method buildFilterRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getFilterRef() {
    return this.filterRef!=null ?this.filterRef.build():null;
  }
  public LocalObjectReference buildFilterRef() {
    return this.filterRef!=null ?this.filterRef.build():null;
  }
  public A withFilterRef(LocalObjectReference filterRef) {
    _visitables.get("filterRef").remove(this.filterRef);
    if (filterRef!=null){ this.filterRef= new LocalObjectReferenceBuilder(filterRef); _visitables.get("filterRef").add(this.filterRef);} else { this.filterRef = null; _visitables.get("filterRef").remove(this.filterRef); } return (A) this;
  }
  public Boolean hasFilterRef() {
    return this.filterRef != null;
  }
  public A withNewFilterRef(String name) {
    return (A)withFilterRef(new LocalObjectReference(name));
  }
  public PackageFilterFluentImpl.FilterRefNested<A> withNewFilterRef() {
    return new PackageFilterFluentImpl.FilterRefNestedImpl();
  }
  public PackageFilterFluentImpl.FilterRefNested<A> withNewFilterRefLike(LocalObjectReference item) {
    return new PackageFilterFluentImpl.FilterRefNestedImpl(item);
  }
  public PackageFilterFluentImpl.FilterRefNested<A> editFilterRef() {
    return withNewFilterRefLike(getFilterRef());
  }
  public PackageFilterFluentImpl.FilterRefNested<A> editOrNewFilterRef() {
    return withNewFilterRefLike(getFilterRef() != null ? getFilterRef(): new LocalObjectReferenceBuilder().build());
  }
  public PackageFilterFluentImpl.FilterRefNested<A> editOrNewFilterRefLike(LocalObjectReference item) {
    return withNewFilterRefLike(getFilterRef() != null ? getFilterRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildLabelSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getLabelSelector() {
    return this.labelSelector!=null ?this.labelSelector.build():null;
  }
  public LabelSelector buildLabelSelector() {
    return this.labelSelector!=null ?this.labelSelector.build():null;
  }
  public A withLabelSelector(LabelSelector labelSelector) {
    _visitables.get("labelSelector").remove(this.labelSelector);
    if (labelSelector!=null){ this.labelSelector= new LabelSelectorBuilder(labelSelector); _visitables.get("labelSelector").add(this.labelSelector);} else { this.labelSelector = null; _visitables.get("labelSelector").remove(this.labelSelector); } return (A) this;
  }
  public Boolean hasLabelSelector() {
    return this.labelSelector != null;
  }
  public PackageFilterFluentImpl.LabelSelectorNested<A> withNewLabelSelector() {
    return new PackageFilterFluentImpl.LabelSelectorNestedImpl();
  }
  public PackageFilterFluentImpl.LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
    return new PackageFilterFluentImpl.LabelSelectorNestedImpl(item);
  }
  public PackageFilterFluentImpl.LabelSelectorNested<A> editLabelSelector() {
    return withNewLabelSelectorLike(getLabelSelector());
  }
  public PackageFilterFluentImpl.LabelSelectorNested<A> editOrNewLabelSelector() {
    return withNewLabelSelectorLike(getLabelSelector() != null ? getLabelSelector(): new LabelSelectorBuilder().build());
  }
  public PackageFilterFluentImpl.LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
    return withNewLabelSelectorLike(getLabelSelector() != null ? getLabelSelector(): item);
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PackageFilterFluentImpl that = (PackageFilterFluentImpl) o;
    if (!java.util.Objects.equals(annotations, that.annotations)) return false;

    if (!java.util.Objects.equals(filterRef, that.filterRef)) return false;

    if (!java.util.Objects.equals(labelSelector, that.labelSelector)) return false;

    if (!java.util.Objects.equals(version, that.version)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(annotations,  filterRef,  labelSelector,  version,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (filterRef != null) { sb.append("filterRef:"); sb.append(filterRef + ","); }
    if (labelSelector != null) { sb.append("labelSelector:"); sb.append(labelSelector + ","); }
    if (version != null) { sb.append("version:"); sb.append(version); }
    sb.append("}");
    return sb.toString();
  }
  class FilterRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<PackageFilterFluentImpl.FilterRefNested<N>> implements PackageFilterFluentImpl.FilterRefNested<N>,Nested<N>{
    FilterRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    FilterRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) PackageFilterFluentImpl.this.withFilterRef(builder.build());
    }
    public N endFilterRef() {
      return and();
    }
    
  }
  class LabelSelectorNestedImpl<N> extends LabelSelectorFluentImpl<PackageFilterFluentImpl.LabelSelectorNested<N>> implements PackageFilterFluentImpl.LabelSelectorNested<N>,Nested<N>{
    LabelSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) PackageFilterFluentImpl.this.withLabelSelector(builder.build());
    }
    public N endLabelSelector() {
      return and();
    }
    
  }
  
}