package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterOverridesBuilder extends ClusterOverridesFluentImpl<ClusterOverridesBuilder> implements VisitableBuilder<ClusterOverrides,ClusterOverridesBuilder>{
  public ClusterOverridesBuilder() {
    this(false);
  }
  public ClusterOverridesBuilder(Boolean validationEnabled) {
    this(new ClusterOverrides(), validationEnabled);
  }
  public ClusterOverridesBuilder(ClusterOverridesFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterOverridesBuilder(ClusterOverridesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterOverrides(), validationEnabled);
  }
  public ClusterOverridesBuilder(ClusterOverridesFluent<?> fluent,ClusterOverrides instance) {
    this(fluent, instance, false);
  }
  public ClusterOverridesBuilder(ClusterOverridesFluent<?> fluent,ClusterOverrides instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withClusterName(instance.getClusterName());
      fluent.withClusterOverrides(instance.getClusterOverrides());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterOverridesBuilder(ClusterOverrides instance) {
    this(instance,false);
  }
  public ClusterOverridesBuilder(ClusterOverrides instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withClusterName(instance.getClusterName());
      this.withClusterOverrides(instance.getClusterOverrides());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterOverridesFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterOverrides build() {
    ClusterOverrides buildable = new ClusterOverrides(fluent.getClusterName(),fluent.getClusterOverrides());
    return buildable;
  }
  
}