package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AnsibleJobsStatusBuilder extends AnsibleJobsStatusFluentImpl<AnsibleJobsStatusBuilder> implements VisitableBuilder<AnsibleJobsStatus,AnsibleJobsStatusBuilder>{
  public AnsibleJobsStatusBuilder() {
    this(false);
  }
  public AnsibleJobsStatusBuilder(Boolean validationEnabled) {
    this(new AnsibleJobsStatus(), validationEnabled);
  }
  public AnsibleJobsStatusBuilder(AnsibleJobsStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public AnsibleJobsStatusBuilder(AnsibleJobsStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AnsibleJobsStatus(), validationEnabled);
  }
  public AnsibleJobsStatusBuilder(AnsibleJobsStatusFluent<?> fluent,AnsibleJobsStatus instance) {
    this(fluent, instance, false);
  }
  public AnsibleJobsStatusBuilder(AnsibleJobsStatusFluent<?> fluent,AnsibleJobsStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastposthookjob(instance.getLastposthookjob());
      fluent.withLastprehookjob(instance.getLastprehookjob());
      fluent.withPosthookjobshistory(instance.getPosthookjobshistory());
      fluent.withPrehookjobshistory(instance.getPrehookjobshistory());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AnsibleJobsStatusBuilder(AnsibleJobsStatus instance) {
    this(instance,false);
  }
  public AnsibleJobsStatusBuilder(AnsibleJobsStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastposthookjob(instance.getLastposthookjob());
      this.withLastprehookjob(instance.getLastprehookjob());
      this.withPosthookjobshistory(instance.getPosthookjobshistory());
      this.withPrehookjobshistory(instance.getPrehookjobshistory());
    }
    this.validationEnabled = validationEnabled; 
  }
  AnsibleJobsStatusFluent<?> fluent;
  Boolean validationEnabled;
  public AnsibleJobsStatus build() {
    AnsibleJobsStatus buildable = new AnsibleJobsStatus(fluent.getLastposthookjob(),fluent.getLastprehookjob(),fluent.getPosthookjobshistory(),fluent.getPrehookjobshistory());
    return buildable;
  }
  
}