package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.placementrule.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GenericClusterReferenceBuilder extends GenericClusterReferenceFluentImpl<GenericClusterReferenceBuilder> implements VisitableBuilder<GenericClusterReference,GenericClusterReferenceBuilder>{
  public GenericClusterReferenceBuilder() {
    this(false);
  }
  public GenericClusterReferenceBuilder(Boolean validationEnabled) {
    this(new GenericClusterReference(), validationEnabled);
  }
  public GenericClusterReferenceBuilder(GenericClusterReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public GenericClusterReferenceBuilder(GenericClusterReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GenericClusterReference(), validationEnabled);
  }
  public GenericClusterReferenceBuilder(GenericClusterReferenceFluent<?> fluent,GenericClusterReference instance) {
    this(fluent, instance, false);
  }
  public GenericClusterReferenceBuilder(GenericClusterReferenceFluent<?> fluent,GenericClusterReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GenericClusterReferenceBuilder(GenericClusterReference instance) {
    this(instance,false);
  }
  public GenericClusterReferenceBuilder(GenericClusterReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  GenericClusterReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public GenericClusterReference build() {
    GenericClusterReference buildable = new GenericClusterReference(fluent.getName());
    return buildable;
  }
  
}