package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HelmRepoBuilder extends HelmRepoFluentImpl<HelmRepoBuilder> implements VisitableBuilder<HelmRepo,HelmRepoBuilder>{
  public HelmRepoBuilder() {
    this(false);
  }
  public HelmRepoBuilder(Boolean validationEnabled) {
    this(new HelmRepo(), validationEnabled);
  }
  public HelmRepoBuilder(HelmRepoFluent<?> fluent) {
    this(fluent, false);
  }
  public HelmRepoBuilder(HelmRepoFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HelmRepo(), validationEnabled);
  }
  public HelmRepoBuilder(HelmRepoFluent<?> fluent,HelmRepo instance) {
    this(fluent, instance, false);
  }
  public HelmRepoBuilder(HelmRepoFluent<?> fluent,HelmRepo instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withUrls(instance.getUrls());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HelmRepoBuilder(HelmRepo instance) {
    this(instance,false);
  }
  public HelmRepoBuilder(HelmRepo instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withUrls(instance.getUrls());
    }
    this.validationEnabled = validationEnabled; 
  }
  HelmRepoFluent<?> fluent;
  Boolean validationEnabled;
  public HelmRepo build() {
    HelmRepo buildable = new HelmRepo(fluent.getUrls());
    return buildable;
  }
  
}