package io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ChannelListBuilder extends ChannelListFluentImpl<ChannelListBuilder> implements VisitableBuilder<ChannelList,ChannelListBuilder>{
  public ChannelListBuilder() {
    this(false);
  }
  public ChannelListBuilder(Boolean validationEnabled) {
    this(new ChannelList(), validationEnabled);
  }
  public ChannelListBuilder(ChannelListFluent<?> fluent) {
    this(fluent, false);
  }
  public ChannelListBuilder(ChannelListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ChannelList(), validationEnabled);
  }
  public ChannelListBuilder(ChannelListFluent<?> fluent,ChannelList instance) {
    this(fluent, instance, false);
  }
  public ChannelListBuilder(ChannelListFluent<?> fluent,ChannelList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ChannelListBuilder(ChannelList instance) {
    this(instance,false);
  }
  public ChannelListBuilder(ChannelList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  ChannelListFluent<?> fluent;
  Boolean validationEnabled;
  public ChannelList build() {
    ChannelList buildable = new ChannelList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}