package io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ChannelGateBuilder extends ChannelGateFluentImpl<ChannelGateBuilder> implements VisitableBuilder<ChannelGate,ChannelGateBuilder>{
  public ChannelGateBuilder() {
    this(false);
  }
  public ChannelGateBuilder(Boolean validationEnabled) {
    this(new ChannelGate(), validationEnabled);
  }
  public ChannelGateBuilder(ChannelGateFluent<?> fluent) {
    this(fluent, false);
  }
  public ChannelGateBuilder(ChannelGateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ChannelGate(), validationEnabled);
  }
  public ChannelGateBuilder(ChannelGateFluent<?> fluent,ChannelGate instance) {
    this(fluent, instance, false);
  }
  public ChannelGateBuilder(ChannelGateFluent<?> fluent,ChannelGate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withLabelSelector(instance.getLabelSelector());
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ChannelGateBuilder(ChannelGate instance) {
    this(instance,false);
  }
  public ChannelGateBuilder(ChannelGate instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withLabelSelector(instance.getLabelSelector());
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  ChannelGateFluent<?> fluent;
  Boolean validationEnabled;
  public ChannelGate build() {
    ChannelGate buildable = new ChannelGate(fluent.getAnnotations(),fluent.getLabelSelector(),fluent.getName());
    return buildable;
  }
  
}