package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContactDataBuilder extends ContactDataFluentImpl<ContactDataBuilder> implements VisitableBuilder<ContactData,ContactDataBuilder>{
  public ContactDataBuilder() {
    this(false);
  }
  public ContactDataBuilder(Boolean validationEnabled) {
    this(new ContactData(), validationEnabled);
  }
  public ContactDataBuilder(ContactDataFluent<?> fluent) {
    this(fluent, false);
  }
  public ContactDataBuilder(ContactDataFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContactData(), validationEnabled);
  }
  public ContactDataBuilder(ContactDataFluent<?> fluent,ContactData instance) {
    this(fluent, instance, false);
  }
  public ContactDataBuilder(ContactDataFluent<?> fluent,ContactData instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withEmail(instance.getEmail());
      fluent.withName(instance.getName());
      fluent.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContactDataBuilder(ContactData instance) {
    this(instance,false);
  }
  public ContactDataBuilder(ContactData instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withEmail(instance.getEmail());
      this.withName(instance.getName());
      this.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContactDataFluent<?> fluent;
  Boolean validationEnabled;
  public ContactData build() {
    ContactData buildable = new ContactData(fluent.getEmail(),fluent.getName(),fluent.getUrl());
    return buildable;
  }
  
}