package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ApplicationSpecBuilder extends ApplicationSpecFluentImpl<ApplicationSpecBuilder> implements VisitableBuilder<ApplicationSpec,ApplicationSpecBuilder>{
  public ApplicationSpecBuilder() {
    this(false);
  }
  public ApplicationSpecBuilder(Boolean validationEnabled) {
    this(new ApplicationSpec(), validationEnabled);
  }
  public ApplicationSpecBuilder(ApplicationSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ApplicationSpecBuilder(ApplicationSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ApplicationSpec(), validationEnabled);
  }
  public ApplicationSpecBuilder(ApplicationSpecFluent<?> fluent,ApplicationSpec instance) {
    this(fluent, instance, false);
  }
  public ApplicationSpecBuilder(ApplicationSpecFluent<?> fluent,ApplicationSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAddOwnerRef(instance.getAddOwnerRef());
      fluent.withAssemblyPhase(instance.getAssemblyPhase());
      fluent.withComponentKinds(instance.getComponentKinds());
      fluent.withDescriptor(instance.getDescriptor());
      fluent.withInfo(instance.getInfo());
      fluent.withSelector(instance.getSelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ApplicationSpecBuilder(ApplicationSpec instance) {
    this(instance,false);
  }
  public ApplicationSpecBuilder(ApplicationSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAddOwnerRef(instance.getAddOwnerRef());
      this.withAssemblyPhase(instance.getAssemblyPhase());
      this.withComponentKinds(instance.getComponentKinds());
      this.withDescriptor(instance.getDescriptor());
      this.withInfo(instance.getInfo());
      this.withSelector(instance.getSelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  ApplicationSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ApplicationSpec build() {
    ApplicationSpec buildable = new ApplicationSpec(fluent.getAddOwnerRef(),fluent.getAssemblyPhase(),fluent.getComponentKinds(),fluent.getDescriptor(),fluent.getInfo(),fluent.getSelector());
    return buildable;
  }
  
}