package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ApplicationFluentImpl<A extends ApplicationFluent<A>> extends BaseFluent<A> implements ApplicationFluent<A>{
  public ApplicationFluentImpl() {
  }
  public ApplicationFluentImpl(Application instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ApplicationSpecBuilder spec;
  private ApplicationStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ApplicationFluentImpl.MetadataNested<A> withNewMetadata() {
    return new ApplicationFluentImpl.MetadataNestedImpl();
  }
  public ApplicationFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ApplicationFluentImpl.MetadataNestedImpl(item);
  }
  public ApplicationFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ApplicationFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ApplicationFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ApplicationSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public ApplicationSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(ApplicationSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new ApplicationSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public ApplicationFluentImpl.SpecNested<A> withNewSpec() {
    return new ApplicationFluentImpl.SpecNestedImpl();
  }
  public ApplicationFluentImpl.SpecNested<A> withNewSpecLike(ApplicationSpec item) {
    return new ApplicationFluentImpl.SpecNestedImpl(item);
  }
  public ApplicationFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public ApplicationFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new ApplicationSpecBuilder().build());
  }
  public ApplicationFluentImpl.SpecNested<A> editOrNewSpecLike(ApplicationSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ApplicationStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public ApplicationStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(ApplicationStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new ApplicationStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public ApplicationFluentImpl.StatusNested<A> withNewStatus() {
    return new ApplicationFluentImpl.StatusNestedImpl();
  }
  public ApplicationFluentImpl.StatusNested<A> withNewStatusLike(ApplicationStatus item) {
    return new ApplicationFluentImpl.StatusNestedImpl(item);
  }
  public ApplicationFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public ApplicationFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new ApplicationStatusBuilder().build());
  }
  public ApplicationFluentImpl.StatusNested<A> editOrNewStatusLike(ApplicationStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ApplicationFluentImpl that = (ApplicationFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ApplicationFluentImpl.MetadataNested<N>> implements ApplicationFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ApplicationFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends ApplicationSpecFluentImpl<ApplicationFluentImpl.SpecNested<N>> implements ApplicationFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(ApplicationSpec item) {
      this.builder = new ApplicationSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new ApplicationSpecBuilder(this);
    }
    ApplicationSpecBuilder builder;
    public N and() {
      return (N) ApplicationFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends ApplicationStatusFluentImpl<ApplicationFluentImpl.StatusNested<N>> implements ApplicationFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(ApplicationStatus item) {
      this.builder = new ApplicationStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new ApplicationStatusBuilder(this);
    }
    ApplicationStatusBuilder builder;
    public N and() {
      return (N) ApplicationFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}