package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ApplicationBuilder extends ApplicationFluentImpl<ApplicationBuilder> implements VisitableBuilder<Application,ApplicationBuilder>{
  public ApplicationBuilder() {
    this(false);
  }
  public ApplicationBuilder(Boolean validationEnabled) {
    this(new Application(), validationEnabled);
  }
  public ApplicationBuilder(ApplicationFluent<?> fluent) {
    this(fluent, false);
  }
  public ApplicationBuilder(ApplicationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Application(), validationEnabled);
  }
  public ApplicationBuilder(ApplicationFluent<?> fluent,Application instance) {
    this(fluent, instance, false);
  }
  public ApplicationBuilder(ApplicationFluent<?> fluent,Application instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ApplicationBuilder(Application instance) {
    this(instance,false);
  }
  public ApplicationBuilder(Application instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  ApplicationFluent<?> fluent;
  Boolean validationEnabled;
  public Application build() {
    Application buildable = new Application(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}