package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubscriptionUnitStatusBuilder extends SubscriptionUnitStatusFluentImpl<SubscriptionUnitStatusBuilder> implements VisitableBuilder<SubscriptionUnitStatus,SubscriptionUnitStatusBuilder>{
  public SubscriptionUnitStatusBuilder() {
    this(false);
  }
  public SubscriptionUnitStatusBuilder(Boolean validationEnabled) {
    this(new SubscriptionUnitStatus(), validationEnabled);
  }
  public SubscriptionUnitStatusBuilder(SubscriptionUnitStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SubscriptionUnitStatusBuilder(SubscriptionUnitStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubscriptionUnitStatus(), validationEnabled);
  }
  public SubscriptionUnitStatusBuilder(SubscriptionUnitStatusFluent<?> fluent,SubscriptionUnitStatus instance) {
    this(fluent, instance, false);
  }
  public SubscriptionUnitStatusBuilder(SubscriptionUnitStatusFluent<?> fluent,SubscriptionUnitStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastUpdateTime(instance.getLastUpdateTime());
      fluent.withMessage(instance.getMessage());
      fluent.withPhase(instance.getPhase());
      fluent.withReason(instance.getReason());
      fluent.withResourceStatus(instance.getResourceStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubscriptionUnitStatusBuilder(SubscriptionUnitStatus instance) {
    this(instance,false);
  }
  public SubscriptionUnitStatusBuilder(SubscriptionUnitStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastUpdateTime(instance.getLastUpdateTime());
      this.withMessage(instance.getMessage());
      this.withPhase(instance.getPhase());
      this.withReason(instance.getReason());
      this.withResourceStatus(instance.getResourceStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubscriptionUnitStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SubscriptionUnitStatus build() {
    SubscriptionUnitStatus buildable = new SubscriptionUnitStatus(fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getPhase(),fluent.getReason(),fluent.getResourceStatus());
    return buildable;
  }
  
}