package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.placementrule.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlacementFluentImpl<A extends PlacementFluent<A>> extends BaseFluent<A> implements PlacementFluent<A>{
  public PlacementFluentImpl() {
  }
  public PlacementFluentImpl(Placement instance) {
    if (instance != null) {
      this.withClusterSelector(instance.getClusterSelector());
      this.withClusters(instance.getClusters());
      this.withLocal(instance.getLocal());
      this.withPlacementRef(instance.getPlacementRef());
    }
  }
  private LabelSelectorBuilder clusterSelector;
  private ArrayList<GenericClusterReferenceBuilder> clusters = new ArrayList<GenericClusterReferenceBuilder>();
  private Boolean local;
  private ObjectReferenceBuilder placementRef;
  
  /**
   * This method has been deprecated, please use method buildClusterSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getClusterSelector() {
    return this.clusterSelector!=null ?this.clusterSelector.build():null;
  }
  public LabelSelector buildClusterSelector() {
    return this.clusterSelector!=null ?this.clusterSelector.build():null;
  }
  public A withClusterSelector(LabelSelector clusterSelector) {
    _visitables.get("clusterSelector").remove(this.clusterSelector);
    if (clusterSelector!=null){ this.clusterSelector= new LabelSelectorBuilder(clusterSelector); _visitables.get("clusterSelector").add(this.clusterSelector);} else { this.clusterSelector = null; _visitables.get("clusterSelector").remove(this.clusterSelector); } return (A) this;
  }
  public Boolean hasClusterSelector() {
    return this.clusterSelector != null;
  }
  public PlacementFluentImpl.ClusterSelectorNested<A> withNewClusterSelector() {
    return new PlacementFluentImpl.ClusterSelectorNestedImpl();
  }
  public PlacementFluentImpl.ClusterSelectorNested<A> withNewClusterSelectorLike(LabelSelector item) {
    return new PlacementFluentImpl.ClusterSelectorNestedImpl(item);
  }
  public PlacementFluentImpl.ClusterSelectorNested<A> editClusterSelector() {
    return withNewClusterSelectorLike(getClusterSelector());
  }
  public PlacementFluentImpl.ClusterSelectorNested<A> editOrNewClusterSelector() {
    return withNewClusterSelectorLike(getClusterSelector() != null ? getClusterSelector(): new LabelSelectorBuilder().build());
  }
  public PlacementFluentImpl.ClusterSelectorNested<A> editOrNewClusterSelectorLike(LabelSelector item) {
    return withNewClusterSelectorLike(getClusterSelector() != null ? getClusterSelector(): item);
  }
  public A addToClusters(int index,GenericClusterReference item) {
    if (this.clusters == null) {this.clusters = new ArrayList<GenericClusterReferenceBuilder>();}
    GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
    if (index < 0 || index >= clusters.size()) { _visitables.get("clusters").add(builder); clusters.add(builder); } else { _visitables.get("clusters").add(index, builder); clusters.add(index, builder);}
    return (A)this;
  }
  public A setToClusters(int index,GenericClusterReference item) {
    if (this.clusters == null) {this.clusters = new ArrayList<GenericClusterReferenceBuilder>();}
    GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
    if (index < 0 || index >= clusters.size()) { _visitables.get("clusters").add(builder); clusters.add(builder); } else { _visitables.get("clusters").set(index, builder); clusters.set(index, builder);}
    return (A)this;
  }
  public A addToClusters(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.placementrule.v1.GenericClusterReference... items) {
    if (this.clusters == null) {this.clusters = new ArrayList<GenericClusterReferenceBuilder>();}
    for (GenericClusterReference item : items) {GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);_visitables.get("clusters").add(builder);this.clusters.add(builder);} return (A)this;
  }
  public A addAllToClusters(Collection<GenericClusterReference> items) {
    if (this.clusters == null) {this.clusters = new ArrayList<GenericClusterReferenceBuilder>();}
    for (GenericClusterReference item : items) {GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);_visitables.get("clusters").add(builder);this.clusters.add(builder);} return (A)this;
  }
  public A removeFromClusters(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.placementrule.v1.GenericClusterReference... items) {
    for (GenericClusterReference item : items) {GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);_visitables.get("clusters").remove(builder);if (this.clusters != null) {this.clusters.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusters(Collection<GenericClusterReference> items) {
    for (GenericClusterReference item : items) {GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);_visitables.get("clusters").remove(builder);if (this.clusters != null) {this.clusters.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusters(Predicate<GenericClusterReferenceBuilder> predicate) {
    if (clusters == null) return (A) this;
    final Iterator<GenericClusterReferenceBuilder> each = clusters.iterator();
    final List visitables = _visitables.get("clusters");
    while (each.hasNext()) {
      GenericClusterReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildClusters instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<GenericClusterReference> getClusters() {
    return clusters != null ? build(clusters) : null;
  }
  public List<GenericClusterReference> buildClusters() {
    return clusters != null ? build(clusters) : null;
  }
  public GenericClusterReference buildCluster(int index) {
    return this.clusters.get(index).build();
  }
  public GenericClusterReference buildFirstCluster() {
    return this.clusters.get(0).build();
  }
  public GenericClusterReference buildLastCluster() {
    return this.clusters.get(clusters.size() - 1).build();
  }
  public GenericClusterReference buildMatchingCluster(Predicate<GenericClusterReferenceBuilder> predicate) {
    for (GenericClusterReferenceBuilder item: clusters) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCluster(Predicate<GenericClusterReferenceBuilder> predicate) {
    for (GenericClusterReferenceBuilder item: clusters) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusters(List<GenericClusterReference> clusters) {
    if (this.clusters != null) { _visitables.get("clusters").clear();}
    if (clusters != null) {this.clusters = new ArrayList(); for (GenericClusterReference item : clusters){this.addToClusters(item);}} else { this.clusters = null;} return (A) this;
  }
  public A withClusters(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.placementrule.v1.GenericClusterReference... clusters) {
    if (this.clusters != null) {this.clusters.clear(); _visitables.remove("clusters"); }
    if (clusters != null) {for (GenericClusterReference item :clusters){ this.addToClusters(item);}} return (A) this;
  }
  public Boolean hasClusters() {
    return clusters != null && !clusters.isEmpty();
  }
  public A addNewCluster(String name) {
    return (A)addToClusters(new GenericClusterReference(name));
  }
  public PlacementFluentImpl.ClustersNested<A> addNewCluster() {
    return new PlacementFluentImpl.ClustersNestedImpl();
  }
  public PlacementFluentImpl.ClustersNested<A> addNewClusterLike(GenericClusterReference item) {
    return new PlacementFluentImpl.ClustersNestedImpl(-1, item);
  }
  public PlacementFluentImpl.ClustersNested<A> setNewClusterLike(int index,GenericClusterReference item) {
    return new PlacementFluentImpl.ClustersNestedImpl(index, item);
  }
  public PlacementFluentImpl.ClustersNested<A> editCluster(int index) {
    if (clusters.size() <= index) throw new RuntimeException("Can't edit clusters. Index exceeds size.");
    return setNewClusterLike(index, buildCluster(index));
  }
  public PlacementFluentImpl.ClustersNested<A> editFirstCluster() {
    if (clusters.size() == 0) throw new RuntimeException("Can't edit first clusters. The list is empty.");
    return setNewClusterLike(0, buildCluster(0));
  }
  public PlacementFluentImpl.ClustersNested<A> editLastCluster() {
    int index = clusters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusters. The list is empty.");
    return setNewClusterLike(index, buildCluster(index));
  }
  public PlacementFluentImpl.ClustersNested<A> editMatchingCluster(Predicate<GenericClusterReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusters.size();i++) { 
    if (predicate.test(clusters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusters. No match found.");
    return setNewClusterLike(index, buildCluster(index));
  }
  public Boolean getLocal() {
    return this.local;
  }
  public A withLocal(Boolean local) {
    this.local=local; return (A) this;
  }
  public Boolean hasLocal() {
    return this.local != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPlacementRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getPlacementRef() {
    return this.placementRef!=null ?this.placementRef.build():null;
  }
  public ObjectReference buildPlacementRef() {
    return this.placementRef!=null ?this.placementRef.build():null;
  }
  public A withPlacementRef(ObjectReference placementRef) {
    _visitables.get("placementRef").remove(this.placementRef);
    if (placementRef!=null){ this.placementRef= new ObjectReferenceBuilder(placementRef); _visitables.get("placementRef").add(this.placementRef);} else { this.placementRef = null; _visitables.get("placementRef").remove(this.placementRef); } return (A) this;
  }
  public Boolean hasPlacementRef() {
    return this.placementRef != null;
  }
  public PlacementFluentImpl.PlacementRefNested<A> withNewPlacementRef() {
    return new PlacementFluentImpl.PlacementRefNestedImpl();
  }
  public PlacementFluentImpl.PlacementRefNested<A> withNewPlacementRefLike(ObjectReference item) {
    return new PlacementFluentImpl.PlacementRefNestedImpl(item);
  }
  public PlacementFluentImpl.PlacementRefNested<A> editPlacementRef() {
    return withNewPlacementRefLike(getPlacementRef());
  }
  public PlacementFluentImpl.PlacementRefNested<A> editOrNewPlacementRef() {
    return withNewPlacementRefLike(getPlacementRef() != null ? getPlacementRef(): new ObjectReferenceBuilder().build());
  }
  public PlacementFluentImpl.PlacementRefNested<A> editOrNewPlacementRefLike(ObjectReference item) {
    return withNewPlacementRefLike(getPlacementRef() != null ? getPlacementRef(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlacementFluentImpl that = (PlacementFluentImpl) o;
    if (!java.util.Objects.equals(clusterSelector, that.clusterSelector)) return false;

    if (!java.util.Objects.equals(clusters, that.clusters)) return false;

    if (!java.util.Objects.equals(local, that.local)) return false;

    if (!java.util.Objects.equals(placementRef, that.placementRef)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusterSelector,  clusters,  local,  placementRef,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterSelector != null) { sb.append("clusterSelector:"); sb.append(clusterSelector + ","); }
    if (clusters != null) { sb.append("clusters:"); sb.append(clusters + ","); }
    if (local != null) { sb.append("local:"); sb.append(local + ","); }
    if (placementRef != null) { sb.append("placementRef:"); sb.append(placementRef); }
    sb.append("}");
    return sb.toString();
  }
  public A withLocal() {
    return withLocal(true);
  }
  class ClusterSelectorNestedImpl<N> extends LabelSelectorFluentImpl<PlacementFluentImpl.ClusterSelectorNested<N>> implements PlacementFluentImpl.ClusterSelectorNested<N>,Nested<N>{
    ClusterSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    ClusterSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) PlacementFluentImpl.this.withClusterSelector(builder.build());
    }
    public N endClusterSelector() {
      return and();
    }
    
  }
  class ClustersNestedImpl<N> extends GenericClusterReferenceFluentImpl<PlacementFluentImpl.ClustersNested<N>> implements PlacementFluentImpl.ClustersNested<N>,Nested<N>{
    ClustersNestedImpl(int index,GenericClusterReference item) {
      this.index = index;
      this.builder = new GenericClusterReferenceBuilder(this, item);
    }
    ClustersNestedImpl() {
      this.index = -1;
      this.builder = new GenericClusterReferenceBuilder(this);
    }
    GenericClusterReferenceBuilder builder;
    int index;
    public N and() {
      return (N) PlacementFluentImpl.this.setToClusters(index,builder.build());
    }
    public N endCluster() {
      return and();
    }
    
  }
  class PlacementRefNestedImpl<N> extends ObjectReferenceFluentImpl<PlacementFluentImpl.PlacementRefNested<N>> implements PlacementFluentImpl.PlacementRefNested<N>,Nested<N>{
    PlacementRefNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    PlacementRefNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) PlacementFluentImpl.this.withPlacementRef(builder.build());
    }
    public N endPlacementRef() {
      return and();
    }
    
  }
  
}