package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SourceBuilder extends SourceFluentImpl<SourceBuilder> implements VisitableBuilder<Source,SourceBuilder>{
  public SourceBuilder() {
    this(false);
  }
  public SourceBuilder(Boolean validationEnabled) {
    this(new Source(), validationEnabled);
  }
  public SourceBuilder(SourceFluent<?> fluent) {
    this(fluent, false);
  }
  public SourceBuilder(SourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Source(), validationEnabled);
  }
  public SourceBuilder(SourceFluent<?> fluent,Source instance) {
    this(fluent, instance, false);
  }
  public SourceBuilder(SourceFluent<?> fluent,Source instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withGit(instance.getGit());
      fluent.withGithub(instance.getGithub());
      fluent.withHelmRepo(instance.getHelmRepo());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SourceBuilder(Source instance) {
    this(instance,false);
  }
  public SourceBuilder(Source instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withGit(instance.getGit());
      this.withGithub(instance.getGithub());
      this.withHelmRepo(instance.getHelmRepo());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  SourceFluent<?> fluent;
  Boolean validationEnabled;
  public Source build() {
    Source buildable = new Source(fluent.getGit(),fluent.getGithub(),fluent.getHelmRepo(),fluent.getType());
    return buildable;
  }
  
}