package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HelmAppReleaseBuilder extends HelmAppReleaseFluentImpl<HelmAppReleaseBuilder> implements VisitableBuilder<HelmAppRelease,HelmAppReleaseBuilder>{
  public HelmAppReleaseBuilder() {
    this(false);
  }
  public HelmAppReleaseBuilder(Boolean validationEnabled) {
    this(new HelmAppRelease(), validationEnabled);
  }
  public HelmAppReleaseBuilder(HelmAppReleaseFluent<?> fluent) {
    this(fluent, false);
  }
  public HelmAppReleaseBuilder(HelmAppReleaseFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HelmAppRelease(), validationEnabled);
  }
  public HelmAppReleaseBuilder(HelmAppReleaseFluent<?> fluent,HelmAppRelease instance) {
    this(fluent, instance, false);
  }
  public HelmAppReleaseBuilder(HelmAppReleaseFluent<?> fluent,HelmAppRelease instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withManifest(instance.getManifest());
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HelmAppReleaseBuilder(HelmAppRelease instance) {
    this(instance,false);
  }
  public HelmAppReleaseBuilder(HelmAppRelease instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withManifest(instance.getManifest());
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  HelmAppReleaseFluent<?> fluent;
  Boolean validationEnabled;
  public HelmAppRelease build() {
    HelmAppRelease buildable = new HelmAppRelease(fluent.getManifest(),fluent.getName());
    return buildable;
  }
  
}