package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitHubBuilder extends GitHubFluentImpl<GitHubBuilder> implements VisitableBuilder<GitHub,GitHubBuilder>{
  public GitHubBuilder() {
    this(false);
  }
  public GitHubBuilder(Boolean validationEnabled) {
    this(new GitHub(), validationEnabled);
  }
  public GitHubBuilder(GitHubFluent<?> fluent) {
    this(fluent, false);
  }
  public GitHubBuilder(GitHubFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitHub(), validationEnabled);
  }
  public GitHubBuilder(GitHubFluent<?> fluent,GitHub instance) {
    this(fluent, instance, false);
  }
  public GitHubBuilder(GitHubFluent<?> fluent,GitHub instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBranch(instance.getBranch());
      fluent.withChartPath(instance.getChartPath());
      fluent.withUrls(instance.getUrls());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GitHubBuilder(GitHub instance) {
    this(instance,false);
  }
  public GitHubBuilder(GitHub instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBranch(instance.getBranch());
      this.withChartPath(instance.getChartPath());
      this.withUrls(instance.getUrls());
    }
    this.validationEnabled = validationEnabled; 
  }
  GitHubFluent<?> fluent;
  Boolean validationEnabled;
  public GitHub build() {
    GitHub buildable = new GitHub(fluent.getBranch(),fluent.getChartPath(),fluent.getUrls());
    return buildable;
  }
  
}