package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceSelectorBuilder extends ServiceSelectorFluentImpl<ServiceSelectorBuilder> implements VisitableBuilder<ServiceSelector,ServiceSelectorBuilder>{
  public ServiceSelectorBuilder() {
    this(false);
  }
  public ServiceSelectorBuilder(Boolean validationEnabled) {
    this(new ServiceSelector(), validationEnabled);
  }
  public ServiceSelectorBuilder(ServiceSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceSelectorBuilder(ServiceSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceSelector(), validationEnabled);
  }
  public ServiceSelectorBuilder(ServiceSelectorFluent<?> fluent,ServiceSelector instance) {
    this(fluent, instance, false);
  }
  public ServiceSelectorBuilder(ServiceSelectorFluent<?> fluent,ServiceSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withFieldPath(instance.getFieldPath());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withPath(instance.getPath());
      fluent.withPort(instance.getPort());
      fluent.withProtocol(instance.getProtocol());
      fluent.withResourceVersion(instance.getResourceVersion());
      fluent.withUid(instance.getUid());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceSelectorBuilder(ServiceSelector instance) {
    this(instance,false);
  }
  public ServiceSelectorBuilder(ServiceSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withFieldPath(instance.getFieldPath());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withPath(instance.getPath());
      this.withPort(instance.getPort());
      this.withProtocol(instance.getProtocol());
      this.withResourceVersion(instance.getResourceVersion());
      this.withUid(instance.getUid());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceSelector build() {
    ServiceSelector buildable = new ServiceSelector(fluent.getApiVersion(),fluent.getFieldPath(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.getPath(),fluent.getPort(),fluent.getProtocol(),fluent.getResourceVersion(),fluent.getUid());
    return buildable;
  }
  
}