package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InfoItemBuilder extends InfoItemFluentImpl<InfoItemBuilder> implements VisitableBuilder<InfoItem,InfoItemBuilder>{
  public InfoItemBuilder() {
    this(false);
  }
  public InfoItemBuilder(Boolean validationEnabled) {
    this(new InfoItem(), validationEnabled);
  }
  public InfoItemBuilder(InfoItemFluent<?> fluent) {
    this(fluent, false);
  }
  public InfoItemBuilder(InfoItemFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InfoItem(), validationEnabled);
  }
  public InfoItemBuilder(InfoItemFluent<?> fluent,InfoItem instance) {
    this(fluent, instance, false);
  }
  public InfoItemBuilder(InfoItemFluent<?> fluent,InfoItem instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withType(instance.getType());
      fluent.withValue(instance.getValue());
      fluent.withValueFrom(instance.getValueFrom());
    }
    this.validationEnabled = validationEnabled; 
  }
  public InfoItemBuilder(InfoItem instance) {
    this(instance,false);
  }
  public InfoItemBuilder(InfoItem instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withType(instance.getType());
      this.withValue(instance.getValue());
      this.withValueFrom(instance.getValueFrom());
    }
    this.validationEnabled = validationEnabled; 
  }
  InfoItemFluent<?> fluent;
  Boolean validationEnabled;
  public InfoItem build() {
    InfoItem buildable = new InfoItem(fluent.getName(),fluent.getType(),fluent.getValue(),fluent.getValueFrom());
    return buildable;
  }
  
}