package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ApplicationStatusBuilder extends ApplicationStatusFluentImpl<ApplicationStatusBuilder> implements VisitableBuilder<ApplicationStatus,ApplicationStatusBuilder>{
  public ApplicationStatusBuilder() {
    this(false);
  }
  public ApplicationStatusBuilder(Boolean validationEnabled) {
    this(new ApplicationStatus(), validationEnabled);
  }
  public ApplicationStatusBuilder(ApplicationStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ApplicationStatusBuilder(ApplicationStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ApplicationStatus(), validationEnabled);
  }
  public ApplicationStatusBuilder(ApplicationStatusFluent<?> fluent,ApplicationStatus instance) {
    this(fluent, instance, false);
  }
  public ApplicationStatusBuilder(ApplicationStatusFluent<?> fluent,ApplicationStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withComponents(instance.getComponents());
      fluent.withComponentsReady(instance.getComponentsReady());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ApplicationStatusBuilder(ApplicationStatus instance) {
    this(instance,false);
  }
  public ApplicationStatusBuilder(ApplicationStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withComponents(instance.getComponents());
      this.withComponentsReady(instance.getComponentsReady());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  ApplicationStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ApplicationStatus build() {
    ApplicationStatus buildable = new ApplicationStatus(fluent.getComponents(),fluent.getComponentsReady(),fluent.getConditions(),fluent.getObservedGeneration());
    return buildable;
  }
  
}