package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HelmReleaseRepoBuilder extends HelmReleaseRepoFluentImpl<HelmReleaseRepoBuilder> implements VisitableBuilder<HelmReleaseRepo,HelmReleaseRepoBuilder>{
  public HelmReleaseRepoBuilder() {
    this(false);
  }
  public HelmReleaseRepoBuilder(Boolean validationEnabled) {
    this(new HelmReleaseRepo(), validationEnabled);
  }
  public HelmReleaseRepoBuilder(HelmReleaseRepoFluent<?> fluent) {
    this(fluent, false);
  }
  public HelmReleaseRepoBuilder(HelmReleaseRepoFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HelmReleaseRepo(), validationEnabled);
  }
  public HelmReleaseRepoBuilder(HelmReleaseRepoFluent<?> fluent,HelmReleaseRepo instance) {
    this(fluent, instance, false);
  }
  public HelmReleaseRepoBuilder(HelmReleaseRepoFluent<?> fluent,HelmReleaseRepo instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAltSource(instance.getAltSource()); 
    fluent.withChartName(instance.getChartName()); 
    fluent.withConfigMapRef(instance.getConfigMapRef()); 
    fluent.withDigest(instance.getDigest()); 
    fluent.withInsecureSkipVerify(instance.getInsecureSkipVerify()); 
    fluent.withSecretRef(instance.getSecretRef()); 
    fluent.withSource(instance.getSource()); 
    fluent.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  public HelmReleaseRepoBuilder(HelmReleaseRepo instance) {
    this(instance,false);
  }
  public HelmReleaseRepoBuilder(HelmReleaseRepo instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAltSource(instance.getAltSource()); 
    this.withChartName(instance.getChartName()); 
    this.withConfigMapRef(instance.getConfigMapRef()); 
    this.withDigest(instance.getDigest()); 
    this.withInsecureSkipVerify(instance.getInsecureSkipVerify()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withSource(instance.getSource()); 
    this.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  HelmReleaseRepoFluent<?> fluent;
  Boolean validationEnabled;
  public HelmReleaseRepo build() {
    HelmReleaseRepo buildable = new HelmReleaseRepo(fluent.getAltSource(),fluent.getChartName(),fluent.getConfigMapRef(),fluent.getDigest(),fluent.getInsecureSkipVerify(),fluent.getSecretRef(),fluent.getSource(),fluent.getVersion());
    return buildable;
  }
  
}