package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GitHubFluentImpl<A extends GitHubFluent<A>> extends BaseFluent<A> implements GitHubFluent<A>{
  public GitHubFluentImpl() {
  }
  public GitHubFluentImpl(GitHub instance) {
    this.withBranch(instance.getBranch()); 
    this.withChartPath(instance.getChartPath()); 
    this.withUrls(instance.getUrls()); 
  }
  private String branch;
  private String chartPath;
  private List<String> urls = new ArrayList<String>();
  public String getBranch() {
    return this.branch;
  }
  public A withBranch(String branch) {
    this.branch=branch; return (A) this;
  }
  public Boolean hasBranch() {
    return this.branch != null;
  }
  public String getChartPath() {
    return this.chartPath;
  }
  public A withChartPath(String chartPath) {
    this.chartPath=chartPath; return (A) this;
  }
  public Boolean hasChartPath() {
    return this.chartPath != null;
  }
  public A addToUrls(Integer index,String item) {
    if (this.urls == null) {this.urls = new ArrayList<String>();}
    this.urls.add(index, item);
    return (A)this;
  }
  public A setToUrls(Integer index,String item) {
    if (this.urls == null) {this.urls = new ArrayList<String>();}
    this.urls.set(index, item); return (A)this;
  }
  public A addToUrls(java.lang.String... items) {
    if (this.urls == null) {this.urls = new ArrayList<String>();}
    for (String item : items) {this.urls.add(item);} return (A)this;
  }
  public A addAllToUrls(Collection<String> items) {
    if (this.urls == null) {this.urls = new ArrayList<String>();}
    for (String item : items) {this.urls.add(item);} return (A)this;
  }
  public A removeFromUrls(java.lang.String... items) {
    for (String item : items) {if (this.urls!= null){ this.urls.remove(item);}} return (A)this;
  }
  public A removeAllFromUrls(Collection<String> items) {
    for (String item : items) {if (this.urls!= null){ this.urls.remove(item);}} return (A)this;
  }
  public List<String> getUrls() {
    return this.urls;
  }
  public String getUrl(Integer index) {
    return this.urls.get(index);
  }
  public String getFirstUrl() {
    return this.urls.get(0);
  }
  public String getLastUrl() {
    return this.urls.get(urls.size() - 1);
  }
  public String getMatchingUrl(Predicate<String> predicate) {
    for (String item: urls) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingUrl(Predicate<String> predicate) {
    for (String item: urls) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUrls(List<String> urls) {
    if (urls != null) {this.urls = new ArrayList(); for (String item : urls){this.addToUrls(item);}} else { this.urls = null;} return (A) this;
  }
  public A withUrls(java.lang.String... urls) {
    if (this.urls != null) {this.urls.clear();}
    if (urls != null) {for (String item :urls){ this.addToUrls(item);}} return (A) this;
  }
  public Boolean hasUrls() {
    return urls != null && !urls.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GitHubFluentImpl that = (GitHubFluentImpl) o;
    if (branch != null ? !branch.equals(that.branch) :that.branch != null) return false;
    if (chartPath != null ? !chartPath.equals(that.chartPath) :that.chartPath != null) return false;
    if (urls != null ? !urls.equals(that.urls) :that.urls != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(branch,  chartPath,  urls,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (branch != null) { sb.append("branch:"); sb.append(branch + ","); }
    if (chartPath != null) { sb.append("chartPath:"); sb.append(chartPath + ","); }
    if (urls != null && !urls.isEmpty()) { sb.append("urls:"); sb.append(urls); }
    sb.append("}");
    return sb.toString();
  }
  
}