package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubscriptionPerClusterStatusBuilder extends SubscriptionPerClusterStatusFluentImpl<SubscriptionPerClusterStatusBuilder> implements VisitableBuilder<SubscriptionPerClusterStatus,SubscriptionPerClusterStatusBuilder>{
  public SubscriptionPerClusterStatusBuilder() {
    this(false);
  }
  public SubscriptionPerClusterStatusBuilder(Boolean validationEnabled) {
    this(new SubscriptionPerClusterStatus(), validationEnabled);
  }
  public SubscriptionPerClusterStatusBuilder(SubscriptionPerClusterStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SubscriptionPerClusterStatusBuilder(SubscriptionPerClusterStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubscriptionPerClusterStatus(), validationEnabled);
  }
  public SubscriptionPerClusterStatusBuilder(SubscriptionPerClusterStatusFluent<?> fluent,SubscriptionPerClusterStatus instance) {
    this(fluent, instance, false);
  }
  public SubscriptionPerClusterStatusBuilder(SubscriptionPerClusterStatusFluent<?> fluent,SubscriptionPerClusterStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPackages(instance.getPackages()); 
    this.validationEnabled = validationEnabled; 
  }
  public SubscriptionPerClusterStatusBuilder(SubscriptionPerClusterStatus instance) {
    this(instance,false);
  }
  public SubscriptionPerClusterStatusBuilder(SubscriptionPerClusterStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withPackages(instance.getPackages()); 
    this.validationEnabled = validationEnabled; 
  }
  SubscriptionPerClusterStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SubscriptionPerClusterStatus build() {
    SubscriptionPerClusterStatus buildable = new SubscriptionPerClusterStatus(fluent.getPackages());
    return buildable;
  }
  
}