package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PackageFilterBuilder extends PackageFilterFluentImpl<PackageFilterBuilder> implements VisitableBuilder<PackageFilter,PackageFilterBuilder>{
  public PackageFilterBuilder() {
    this(false);
  }
  public PackageFilterBuilder(Boolean validationEnabled) {
    this(new PackageFilter(), validationEnabled);
  }
  public PackageFilterBuilder(PackageFilterFluent<?> fluent) {
    this(fluent, false);
  }
  public PackageFilterBuilder(PackageFilterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PackageFilter(), validationEnabled);
  }
  public PackageFilterBuilder(PackageFilterFluent<?> fluent,PackageFilter instance) {
    this(fluent, instance, false);
  }
  public PackageFilterBuilder(PackageFilterFluent<?> fluent,PackageFilter instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAnnotations(instance.getAnnotations()); 
    fluent.withFilterRef(instance.getFilterRef()); 
    fluent.withLabelSelector(instance.getLabelSelector()); 
    fluent.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  public PackageFilterBuilder(PackageFilter instance) {
    this(instance,false);
  }
  public PackageFilterBuilder(PackageFilter instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAnnotations(instance.getAnnotations()); 
    this.withFilterRef(instance.getFilterRef()); 
    this.withLabelSelector(instance.getLabelSelector()); 
    this.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  PackageFilterFluent<?> fluent;
  Boolean validationEnabled;
  public PackageFilter build() {
    PackageFilter buildable = new PackageFilter(fluent.getAnnotations(),fluent.getFilterRef(),fluent.getLabelSelector(),fluent.getVersion());
    return buildable;
  }
  
}