package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HelmReleaseListBuilder extends HelmReleaseListFluentImpl<HelmReleaseListBuilder> implements VisitableBuilder<HelmReleaseList,HelmReleaseListBuilder>{
  public HelmReleaseListBuilder() {
    this(false);
  }
  public HelmReleaseListBuilder(Boolean validationEnabled) {
    this(new HelmReleaseList(), validationEnabled);
  }
  public HelmReleaseListBuilder(HelmReleaseListFluent<?> fluent) {
    this(fluent, false);
  }
  public HelmReleaseListBuilder(HelmReleaseListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HelmReleaseList(), validationEnabled);
  }
  public HelmReleaseListBuilder(HelmReleaseListFluent<?> fluent,HelmReleaseList instance) {
    this(fluent, instance, false);
  }
  public HelmReleaseListBuilder(HelmReleaseListFluent<?> fluent,HelmReleaseList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public HelmReleaseListBuilder(HelmReleaseList instance) {
    this(instance,false);
  }
  public HelmReleaseListBuilder(HelmReleaseList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  HelmReleaseListFluent<?> fluent;
  Boolean validationEnabled;
  public HelmReleaseList build() {
    HelmReleaseList buildable = new HelmReleaseList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}