package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HelmReleaseFluentImpl<A extends HelmReleaseFluent<A>> extends BaseFluent<A> implements HelmReleaseFluent<A>{
  public HelmReleaseFluentImpl() {
  }
  public HelmReleaseFluentImpl(HelmRelease instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRepo(instance.getRepo()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private HelmReleaseRepoBuilder repo;
  private Map<String,Object> spec;
  private HelmAppStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public HelmReleaseFluent.MetadataNested<A> withNewMetadata() {
    return new HelmReleaseFluentImpl.MetadataNestedImpl();
  }
  public HelmReleaseFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new HelmReleaseFluentImpl.MetadataNestedImpl(item);
  }
  public HelmReleaseFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public HelmReleaseFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public HelmReleaseFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRepo instead.
   * @return The buildable object.
   */
  @Deprecated
  public HelmReleaseRepo getRepo() {
    return this.repo!=null ?this.repo.build():null;
  }
  public HelmReleaseRepo buildRepo() {
    return this.repo!=null ?this.repo.build():null;
  }
  public A withRepo(HelmReleaseRepo repo) {
    _visitables.get("repo").remove(this.repo);
    if (repo!=null){ this.repo= new HelmReleaseRepoBuilder(repo); _visitables.get("repo").add(this.repo);} else { this.repo = null; _visitables.get("repo").remove(this.repo); } return (A) this;
  }
  public Boolean hasRepo() {
    return this.repo != null;
  }
  public HelmReleaseFluent.RepoNested<A> withNewRepo() {
    return new HelmReleaseFluentImpl.RepoNestedImpl();
  }
  public HelmReleaseFluent.RepoNested<A> withNewRepoLike(HelmReleaseRepo item) {
    return new HelmReleaseFluentImpl.RepoNestedImpl(item);
  }
  public HelmReleaseFluent.RepoNested<A> editRepo() {
    return withNewRepoLike(getRepo());
  }
  public HelmReleaseFluent.RepoNested<A> editOrNewRepo() {
    return withNewRepoLike(getRepo() != null ? getRepo(): new HelmReleaseRepoBuilder().build());
  }
  public HelmReleaseFluent.RepoNested<A> editOrNewRepoLike(HelmReleaseRepo item) {
    return withNewRepoLike(getRepo() != null ? getRepo(): item);
  }
  public A addToSpec(String key,Object value) {
    if(this.spec == null && key != null && value != null) { this.spec = new LinkedHashMap(); }
    if(key != null && value != null) {this.spec.put(key, value);} return (A)this;
  }
  public A addToSpec(Map<String,Object> map) {
    if(this.spec == null && map != null) { this.spec = new LinkedHashMap(); }
    if(map != null) { this.spec.putAll(map);} return (A)this;
  }
  public A removeFromSpec(String key) {
    if(this.spec == null) { return (A) this; }
    if(key != null && this.spec != null) {this.spec.remove(key);} return (A)this;
  }
  public A removeFromSpec(Map<String,Object> map) {
    if(this.spec == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.spec != null){this.spec.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getSpec() {
    return this.spec;
  }
  public <K,V>A withSpec(Map<String,Object> spec) {
    if (spec == null) { this.spec =  null;} else {this.spec = new LinkedHashMap(spec);} return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public HelmAppStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public HelmAppStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(HelmAppStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new HelmAppStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public HelmReleaseFluent.StatusNested<A> withNewStatus() {
    return new HelmReleaseFluentImpl.StatusNestedImpl();
  }
  public HelmReleaseFluent.StatusNested<A> withNewStatusLike(HelmAppStatus item) {
    return new HelmReleaseFluentImpl.StatusNestedImpl(item);
  }
  public HelmReleaseFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public HelmReleaseFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new HelmAppStatusBuilder().build());
  }
  public HelmReleaseFluent.StatusNested<A> editOrNewStatusLike(HelmAppStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HelmReleaseFluentImpl that = (HelmReleaseFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (repo != null ? !repo.equals(that.repo) :that.repo != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  repo,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (repo != null) { sb.append("repo:"); sb.append(repo + ","); }
    if (spec != null && !spec.isEmpty()) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<HelmReleaseFluent.MetadataNested<N>> implements HelmReleaseFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) HelmReleaseFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class RepoNestedImpl<N> extends HelmReleaseRepoFluentImpl<HelmReleaseFluent.RepoNested<N>> implements HelmReleaseFluent.RepoNested<N>,Nested<N>{
    RepoNestedImpl(HelmReleaseRepo item) {
      this.builder = new HelmReleaseRepoBuilder(this, item);
    }
    RepoNestedImpl() {
      this.builder = new HelmReleaseRepoBuilder(this);
    }
    HelmReleaseRepoBuilder builder;
    public N and() {
      return (N) HelmReleaseFluentImpl.this.withRepo(builder.build());
    }
    public N endRepo() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends HelmAppStatusFluentImpl<HelmReleaseFluent.StatusNested<N>> implements HelmReleaseFluent.StatusNested<N>,Nested<N>{
    StatusNestedImpl(HelmAppStatus item) {
      this.builder = new HelmAppStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new HelmAppStatusBuilder(this);
    }
    HelmAppStatusBuilder builder;
    public N and() {
      return (N) HelmReleaseFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}