package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TimeWindowFluentImpl<A extends TimeWindowFluent<A>> extends BaseFluent<A> implements TimeWindowFluent<A>{
  public TimeWindowFluentImpl() {
  }
  public TimeWindowFluentImpl(TimeWindow instance) {
    this.withDaysofweek(instance.getDaysofweek()); 
    this.withHours(instance.getHours()); 
    this.withLocation(instance.getLocation()); 
    this.withWindowtype(instance.getWindowtype()); 
  }
  private List<String> daysofweek = new ArrayList<String>();
  private ArrayList<HourRangeBuilder> hours = new ArrayList<HourRangeBuilder>();
  private String location;
  private String windowtype;
  public A addToDaysofweek(Integer index,String item) {
    if (this.daysofweek == null) {this.daysofweek = new ArrayList<String>();}
    this.daysofweek.add(index, item);
    return (A)this;
  }
  public A setToDaysofweek(Integer index,String item) {
    if (this.daysofweek == null) {this.daysofweek = new ArrayList<String>();}
    this.daysofweek.set(index, item); return (A)this;
  }
  public A addToDaysofweek(java.lang.String... items) {
    if (this.daysofweek == null) {this.daysofweek = new ArrayList<String>();}
    for (String item : items) {this.daysofweek.add(item);} return (A)this;
  }
  public A addAllToDaysofweek(Collection<String> items) {
    if (this.daysofweek == null) {this.daysofweek = new ArrayList<String>();}
    for (String item : items) {this.daysofweek.add(item);} return (A)this;
  }
  public A removeFromDaysofweek(java.lang.String... items) {
    for (String item : items) {if (this.daysofweek!= null){ this.daysofweek.remove(item);}} return (A)this;
  }
  public A removeAllFromDaysofweek(Collection<String> items) {
    for (String item : items) {if (this.daysofweek!= null){ this.daysofweek.remove(item);}} return (A)this;
  }
  public List<String> getDaysofweek() {
    return this.daysofweek;
  }
  public String getDaysofweek(Integer index) {
    return this.daysofweek.get(index);
  }
  public String getFirstDaysofweek() {
    return this.daysofweek.get(0);
  }
  public String getLastDaysofweek() {
    return this.daysofweek.get(daysofweek.size() - 1);
  }
  public String getMatchingDaysofweek(Predicate<String> predicate) {
    for (String item: daysofweek) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDaysofweek(Predicate<String> predicate) {
    for (String item: daysofweek) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDaysofweek(List<String> daysofweek) {
    if (daysofweek != null) {this.daysofweek = new ArrayList(); for (String item : daysofweek){this.addToDaysofweek(item);}} else { this.daysofweek = null;} return (A) this;
  }
  public A withDaysofweek(java.lang.String... daysofweek) {
    if (this.daysofweek != null) {this.daysofweek.clear();}
    if (daysofweek != null) {for (String item :daysofweek){ this.addToDaysofweek(item);}} return (A) this;
  }
  public Boolean hasDaysofweek() {
    return daysofweek != null && !daysofweek.isEmpty();
  }
  public A addToHours(Integer index,HourRange item) {
    if (this.hours == null) {this.hours = new ArrayList<HourRangeBuilder>();}
    HourRangeBuilder builder = new HourRangeBuilder(item);_visitables.get("hours").add(index >= 0 ? index : _visitables.get("hours").size(), builder);this.hours.add(index >= 0 ? index : hours.size(), builder); return (A)this;
  }
  public A setToHours(Integer index,HourRange item) {
    if (this.hours == null) {this.hours = new ArrayList<HourRangeBuilder>();}
    HourRangeBuilder builder = new HourRangeBuilder(item);
    if (index < 0 || index >= _visitables.get("hours").size()) { _visitables.get("hours").add(builder); } else { _visitables.get("hours").set(index, builder);}
    if (index < 0 || index >= hours.size()) { hours.add(builder); } else { hours.set(index, builder);}
     return (A)this;
  }
  public A addToHours(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.HourRange... items) {
    if (this.hours == null) {this.hours = new ArrayList<HourRangeBuilder>();}
    for (HourRange item : items) {HourRangeBuilder builder = new HourRangeBuilder(item);_visitables.get("hours").add(builder);this.hours.add(builder);} return (A)this;
  }
  public A addAllToHours(Collection<HourRange> items) {
    if (this.hours == null) {this.hours = new ArrayList<HourRangeBuilder>();}
    for (HourRange item : items) {HourRangeBuilder builder = new HourRangeBuilder(item);_visitables.get("hours").add(builder);this.hours.add(builder);} return (A)this;
  }
  public A removeFromHours(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.HourRange... items) {
    for (HourRange item : items) {HourRangeBuilder builder = new HourRangeBuilder(item);_visitables.get("hours").remove(builder);if (this.hours != null) {this.hours.remove(builder);}} return (A)this;
  }
  public A removeAllFromHours(Collection<HourRange> items) {
    for (HourRange item : items) {HourRangeBuilder builder = new HourRangeBuilder(item);_visitables.get("hours").remove(builder);if (this.hours != null) {this.hours.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHours(Predicate<HourRangeBuilder> predicate) {
    if (hours == null) return (A) this;
    final Iterator<HourRangeBuilder> each = hours.iterator();
    final List visitables = _visitables.get("hours");
    while (each.hasNext()) {
      HourRangeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildHours instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HourRange> getHours() {
    return hours != null ? build(hours) : null;
  }
  public List<HourRange> buildHours() {
    return hours != null ? build(hours) : null;
  }
  public HourRange buildHour(Integer index) {
    return this.hours.get(index).build();
  }
  public HourRange buildFirstHour() {
    return this.hours.get(0).build();
  }
  public HourRange buildLastHour() {
    return this.hours.get(hours.size() - 1).build();
  }
  public HourRange buildMatchingHour(Predicate<HourRangeBuilder> predicate) {
    for (HourRangeBuilder item: hours) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingHour(Predicate<HourRangeBuilder> predicate) {
    for (HourRangeBuilder item: hours) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHours(List<HourRange> hours) {
    if (this.hours != null) { _visitables.get("hours").removeAll(this.hours);}
    if (hours != null) {this.hours = new ArrayList(); for (HourRange item : hours){this.addToHours(item);}} else { this.hours = null;} return (A) this;
  }
  public A withHours(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.HourRange... hours) {
    if (this.hours != null) {this.hours.clear();}
    if (hours != null) {for (HourRange item :hours){ this.addToHours(item);}} return (A) this;
  }
  public Boolean hasHours() {
    return hours != null && !hours.isEmpty();
  }
  public A addNewHour(String end,String start) {
    return (A)addToHours(new HourRange(end, start));
  }
  public TimeWindowFluent.HoursNested<A> addNewHour() {
    return new TimeWindowFluentImpl.HoursNestedImpl();
  }
  public TimeWindowFluent.HoursNested<A> addNewHourLike(HourRange item) {
    return new TimeWindowFluentImpl.HoursNestedImpl(-1, item);
  }
  public TimeWindowFluent.HoursNested<A> setNewHourLike(Integer index,HourRange item) {
    return new TimeWindowFluentImpl.HoursNestedImpl(index, item);
  }
  public TimeWindowFluent.HoursNested<A> editHour(Integer index) {
    if (hours.size() <= index) throw new RuntimeException("Can't edit hours. Index exceeds size.");
    return setNewHourLike(index, buildHour(index));
  }
  public TimeWindowFluent.HoursNested<A> editFirstHour() {
    if (hours.size() == 0) throw new RuntimeException("Can't edit first hours. The list is empty.");
    return setNewHourLike(0, buildHour(0));
  }
  public TimeWindowFluent.HoursNested<A> editLastHour() {
    int index = hours.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last hours. The list is empty.");
    return setNewHourLike(index, buildHour(index));
  }
  public TimeWindowFluent.HoursNested<A> editMatchingHour(Predicate<HourRangeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<hours.size();i++) { 
    if (predicate.test(hours.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching hours. No match found.");
    return setNewHourLike(index, buildHour(index));
  }
  public String getLocation() {
    return this.location;
  }
  public A withLocation(String location) {
    this.location=location; return (A) this;
  }
  public Boolean hasLocation() {
    return this.location != null;
  }
  public String getWindowtype() {
    return this.windowtype;
  }
  public A withWindowtype(String windowtype) {
    this.windowtype=windowtype; return (A) this;
  }
  public Boolean hasWindowtype() {
    return this.windowtype != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TimeWindowFluentImpl that = (TimeWindowFluentImpl) o;
    if (daysofweek != null ? !daysofweek.equals(that.daysofweek) :that.daysofweek != null) return false;
    if (hours != null ? !hours.equals(that.hours) :that.hours != null) return false;
    if (location != null ? !location.equals(that.location) :that.location != null) return false;
    if (windowtype != null ? !windowtype.equals(that.windowtype) :that.windowtype != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(daysofweek,  hours,  location,  windowtype,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (daysofweek != null && !daysofweek.isEmpty()) { sb.append("daysofweek:"); sb.append(daysofweek + ","); }
    if (hours != null && !hours.isEmpty()) { sb.append("hours:"); sb.append(hours + ","); }
    if (location != null) { sb.append("location:"); sb.append(location + ","); }
    if (windowtype != null) { sb.append("windowtype:"); sb.append(windowtype); }
    sb.append("}");
    return sb.toString();
  }
  class HoursNestedImpl<N> extends HourRangeFluentImpl<TimeWindowFluent.HoursNested<N>> implements TimeWindowFluent.HoursNested<N>,Nested<N>{
    HoursNestedImpl(Integer index,HourRange item) {
      this.index = index;
      this.builder = new HourRangeBuilder(this, item);
    }
    HoursNestedImpl() {
      this.index = -1;
      this.builder = new HourRangeBuilder(this);
    }
    HourRangeBuilder builder;
    Integer index;
    public N and() {
      return (N) TimeWindowFluentImpl.this.setToHours(index,builder.build());
    }
    public N endHour() {
      return and();
    }
    
  }
  
}