package io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ChannelBuilder extends ChannelFluentImpl<ChannelBuilder> implements VisitableBuilder<Channel,ChannelBuilder>{
  public ChannelBuilder() {
    this(false);
  }
  public ChannelBuilder(Boolean validationEnabled) {
    this(new Channel(), validationEnabled);
  }
  public ChannelBuilder(ChannelFluent<?> fluent) {
    this(fluent, false);
  }
  public ChannelBuilder(ChannelFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Channel(), validationEnabled);
  }
  public ChannelBuilder(ChannelFluent<?> fluent,Channel instance) {
    this(fluent, instance, false);
  }
  public ChannelBuilder(ChannelFluent<?> fluent,Channel instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public ChannelBuilder(Channel instance) {
    this(instance,false);
  }
  public ChannelBuilder(Channel instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  ChannelFluent<?> fluent;
  Boolean validationEnabled;
  public Channel build() {
    Channel buildable = new Channel(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}