package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.placementrule.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlacementBuilder extends PlacementFluentImpl<PlacementBuilder> implements VisitableBuilder<Placement,PlacementBuilder>{
  public PlacementBuilder() {
    this(false);
  }
  public PlacementBuilder(Boolean validationEnabled) {
    this(new Placement(), validationEnabled);
  }
  public PlacementBuilder(PlacementFluent<?> fluent) {
    this(fluent, false);
  }
  public PlacementBuilder(PlacementFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Placement(), validationEnabled);
  }
  public PlacementBuilder(PlacementFluent<?> fluent,Placement instance) {
    this(fluent, instance, false);
  }
  public PlacementBuilder(PlacementFluent<?> fluent,Placement instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterSelector(instance.getClusterSelector()); 
    fluent.withClusters(instance.getClusters()); 
    fluent.withLocal(instance.getLocal()); 
    fluent.withPlacementRef(instance.getPlacementRef()); 
    this.validationEnabled = validationEnabled; 
  }
  public PlacementBuilder(Placement instance) {
    this(instance,false);
  }
  public PlacementBuilder(Placement instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterSelector(instance.getClusterSelector()); 
    this.withClusters(instance.getClusters()); 
    this.withLocal(instance.getLocal()); 
    this.withPlacementRef(instance.getPlacementRef()); 
    this.validationEnabled = validationEnabled; 
  }
  PlacementFluent<?> fluent;
  Boolean validationEnabled;
  public Placement build() {
    Placement buildable = new Placement(fluent.getClusterSelector(),fluent.getClusters(),fluent.getLocal(),fluent.getPlacementRef());
    return buildable;
  }
  
}