package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageSpecBuilder extends ImageSpecFluentImpl<ImageSpecBuilder> implements VisitableBuilder<ImageSpec,ImageSpecBuilder>{
  public ImageSpecBuilder() {
    this(false);
  }
  public ImageSpecBuilder(Boolean validationEnabled) {
    this(new ImageSpec(), validationEnabled);
  }
  public ImageSpecBuilder(ImageSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageSpecBuilder(ImageSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageSpec(), validationEnabled);
  }
  public ImageSpecBuilder(ImageSpecFluent<?> fluent,ImageSpec instance) {
    this(fluent, instance, false);
  }
  public ImageSpecBuilder(ImageSpecFluent<?> fluent,ImageSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withSize(instance.getSize()); 
    fluent.withSrc(instance.getSrc()); 
    fluent.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  public ImageSpecBuilder(ImageSpec instance) {
    this(instance,false);
  }
  public ImageSpecBuilder(ImageSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withSize(instance.getSize()); 
    this.withSrc(instance.getSrc()); 
    this.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  ImageSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ImageSpec build() {
    ImageSpec buildable = new ImageSpec(fluent.getSize(),fluent.getSrc(),fluent.getType());
    return buildable;
  }
  
}