/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1.Git;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GitFluent<A extends GitFluent<A>>
extends BaseFluent<A> {
    private String branch;
    private String chartPath;
    private List<String> urls = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public GitFluent() {
    }

    public GitFluent(Git instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Git instance) {
        Git git = instance = instance != null ? instance : new Git();
        if (instance != null) {
            this.withBranch(instance.getBranch());
            this.withChartPath(instance.getChartPath());
            this.withUrls(instance.getUrls());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getBranch() {
        return this.branch;
    }

    public A withBranch(String branch) {
        this.branch = branch;
        return (A)((Object)this);
    }

    public boolean hasBranch() {
        return this.branch != null;
    }

    public String getChartPath() {
        return this.chartPath;
    }

    public A withChartPath(String chartPath) {
        this.chartPath = chartPath;
        return (A)((Object)this);
    }

    public boolean hasChartPath() {
        return this.chartPath != null;
    }

    public A addToUrls(int index, String item) {
        if (this.urls == null) {
            this.urls = new ArrayList<String>();
        }
        this.urls.add(index, item);
        return (A)((Object)this);
    }

    public A setToUrls(int index, String item) {
        if (this.urls == null) {
            this.urls = new ArrayList<String>();
        }
        this.urls.set(index, item);
        return (A)((Object)this);
    }

    public A addToUrls(String ... items) {
        if (this.urls == null) {
            this.urls = new ArrayList<String>();
        }
        for (String item : items) {
            this.urls.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToUrls(Collection<String> items) {
        if (this.urls == null) {
            this.urls = new ArrayList<String>();
        }
        for (String item : items) {
            this.urls.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromUrls(String ... items) {
        if (this.urls == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.urls.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromUrls(Collection<String> items) {
        if (this.urls == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.urls.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public String getUrl(int index) {
        return this.urls.get(index);
    }

    public String getFirstUrl() {
        return this.urls.get(0);
    }

    public String getLastUrl() {
        return this.urls.get(this.urls.size() - 1);
    }

    public String getMatchingUrl(Predicate<String> predicate) {
        for (String item : this.urls) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingUrl(Predicate<String> predicate) {
        for (String item : this.urls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUrls(List<String> urls) {
        if (urls != null) {
            this.urls = new ArrayList<String>();
            for (String item : urls) {
                this.addToUrls(item);
            }
        } else {
            this.urls = null;
        }
        return (A)((Object)this);
    }

    public A withUrls(String ... urls) {
        if (this.urls != null) {
            this.urls.clear();
            this._visitables.remove((Object)"urls");
        }
        if (urls != null) {
            for (String item : urls) {
                this.addToUrls(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasUrls() {
        return this.urls != null && !this.urls.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitFluent that = (GitFluent)((Object)o);
        if (!Objects.equals(this.branch, that.branch)) {
            return false;
        }
        if (!Objects.equals(this.chartPath, that.chartPath)) {
            return false;
        }
        if (!Objects.equals(this.urls, that.urls)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.branch, this.chartPath, this.urls, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.branch != null) {
            sb.append("branch:");
            sb.append(this.branch + ",");
        }
        if (this.chartPath != null) {
            sb.append("chartPath:");
            sb.append(this.chartPath + ",");
        }
        if (this.urls != null && !this.urls.isEmpty()) {
            sb.append("urls:");
            sb.append(this.urls + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

