/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ContactData;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ContactDataBuilder;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ContactDataFluent;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Descriptor;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ImageSpec;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ImageSpecBuilder;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ImageSpecFluent;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Link;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.LinkBuilder;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.LinkFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DescriptorFluent<A extends DescriptorFluent<A>>
extends BaseFluent<A> {
    private String description;
    private ArrayList<ImageSpecBuilder> icons = new ArrayList();
    private List<String> keywords = new ArrayList<String>();
    private ArrayList<LinkBuilder> links = new ArrayList();
    private ArrayList<ContactDataBuilder> maintainers = new ArrayList();
    private String notes;
    private ArrayList<ContactDataBuilder> owners = new ArrayList();
    private String type;
    private String version;
    private Map<String, Object> additionalProperties;

    public DescriptorFluent() {
    }

    public DescriptorFluent(Descriptor instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Descriptor instance) {
        Descriptor descriptor = instance = instance != null ? instance : new Descriptor();
        if (instance != null) {
            this.withDescription(instance.getDescription());
            this.withIcons(instance.getIcons());
            this.withKeywords(instance.getKeywords());
            this.withLinks(instance.getLinks());
            this.withMaintainers(instance.getMaintainers());
            this.withNotes(instance.getNotes());
            this.withOwners(instance.getOwners());
            this.withType(instance.getType());
            this.withVersion(instance.getVersion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description = description;
        return (A)((Object)this);
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public A addToIcons(int index, ImageSpec item) {
        if (this.icons == null) {
            this.icons = new ArrayList();
        }
        ImageSpecBuilder builder = new ImageSpecBuilder(item);
        if (index < 0 || index >= this.icons.size()) {
            this._visitables.get((Object)"icons").add(builder);
            this.icons.add(builder);
        } else {
            this._visitables.get((Object)"icons").add(index, builder);
            this.icons.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToIcons(int index, ImageSpec item) {
        if (this.icons == null) {
            this.icons = new ArrayList();
        }
        ImageSpecBuilder builder = new ImageSpecBuilder(item);
        if (index < 0 || index >= this.icons.size()) {
            this._visitables.get((Object)"icons").add(builder);
            this.icons.add(builder);
        } else {
            this._visitables.get((Object)"icons").set(index, builder);
            this.icons.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToIcons(ImageSpec ... items) {
        if (this.icons == null) {
            this.icons = new ArrayList();
        }
        for (ImageSpec item : items) {
            ImageSpecBuilder builder = new ImageSpecBuilder(item);
            this._visitables.get((Object)"icons").add(builder);
            this.icons.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToIcons(Collection<ImageSpec> items) {
        if (this.icons == null) {
            this.icons = new ArrayList();
        }
        for (ImageSpec item : items) {
            ImageSpecBuilder builder = new ImageSpecBuilder(item);
            this._visitables.get((Object)"icons").add(builder);
            this.icons.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromIcons(ImageSpec ... items) {
        if (this.icons == null) {
            return (A)((Object)this);
        }
        for (ImageSpec item : items) {
            ImageSpecBuilder builder = new ImageSpecBuilder(item);
            this._visitables.get((Object)"icons").remove((Object)builder);
            this.icons.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIcons(Collection<ImageSpec> items) {
        if (this.icons == null) {
            return (A)((Object)this);
        }
        for (ImageSpec item : items) {
            ImageSpecBuilder builder = new ImageSpecBuilder(item);
            this._visitables.get((Object)"icons").remove((Object)builder);
            this.icons.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromIcons(Predicate<ImageSpecBuilder> predicate) {
        if (this.icons == null) {
            return (A)((Object)this);
        }
        Iterator<ImageSpecBuilder> each = this.icons.iterator();
        List visitables = this._visitables.get((Object)"icons");
        while (each.hasNext()) {
            ImageSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ImageSpec> buildIcons() {
        return this.icons != null ? DescriptorFluent.build(this.icons) : null;
    }

    public ImageSpec buildIcon(int index) {
        return this.icons.get(index).build();
    }

    public ImageSpec buildFirstIcon() {
        return this.icons.get(0).build();
    }

    public ImageSpec buildLastIcon() {
        return this.icons.get(this.icons.size() - 1).build();
    }

    public ImageSpec buildMatchingIcon(Predicate<ImageSpecBuilder> predicate) {
        for (ImageSpecBuilder item : this.icons) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingIcon(Predicate<ImageSpecBuilder> predicate) {
        for (ImageSpecBuilder item : this.icons) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIcons(List<ImageSpec> icons) {
        if (this.icons != null) {
            this._visitables.get((Object)"icons").clear();
        }
        if (icons != null) {
            this.icons = new ArrayList();
            for (ImageSpec item : icons) {
                this.addToIcons(item);
            }
        } else {
            this.icons = null;
        }
        return (A)((Object)this);
    }

    public A withIcons(ImageSpec ... icons) {
        if (this.icons != null) {
            this.icons.clear();
            this._visitables.remove((Object)"icons");
        }
        if (icons != null) {
            for (ImageSpec item : icons) {
                this.addToIcons(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasIcons() {
        return this.icons != null && !this.icons.isEmpty();
    }

    public A addNewIcon(String size, String src, String type) {
        return this.addToIcons(new ImageSpec(size, src, type));
    }

    public IconsNested<A> addNewIcon() {
        return new IconsNested(-1, null);
    }

    public IconsNested<A> addNewIconLike(ImageSpec item) {
        return new IconsNested(-1, item);
    }

    public IconsNested<A> setNewIconLike(int index, ImageSpec item) {
        return new IconsNested(index, item);
    }

    public IconsNested<A> editIcon(int index) {
        if (this.icons.size() <= index) {
            throw new RuntimeException("Can't edit icons. Index exceeds size.");
        }
        return this.setNewIconLike(index, this.buildIcon(index));
    }

    public IconsNested<A> editFirstIcon() {
        if (this.icons.size() == 0) {
            throw new RuntimeException("Can't edit first icons. The list is empty.");
        }
        return this.setNewIconLike(0, this.buildIcon(0));
    }

    public IconsNested<A> editLastIcon() {
        int index = this.icons.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last icons. The list is empty.");
        }
        return this.setNewIconLike(index, this.buildIcon(index));
    }

    public IconsNested<A> editMatchingIcon(Predicate<ImageSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.icons.size(); ++i) {
            if (!predicate.test(this.icons.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching icons. No match found.");
        }
        return this.setNewIconLike(index, this.buildIcon(index));
    }

    public A addToKeywords(int index, String item) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(index, item);
        return (A)((Object)this);
    }

    public A setToKeywords(int index, String item) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.set(index, item);
        return (A)((Object)this);
    }

    public A addToKeywords(String ... items) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        for (String item : items) {
            this.keywords.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToKeywords(Collection<String> items) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        for (String item : items) {
            this.keywords.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromKeywords(String ... items) {
        if (this.keywords == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.keywords.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromKeywords(Collection<String> items) {
        if (this.keywords == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.keywords.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public String getKeyword(int index) {
        return this.keywords.get(index);
    }

    public String getFirstKeyword() {
        return this.keywords.get(0);
    }

    public String getLastKeyword() {
        return this.keywords.get(this.keywords.size() - 1);
    }

    public String getMatchingKeyword(Predicate<String> predicate) {
        for (String item : this.keywords) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingKeyword(Predicate<String> predicate) {
        for (String item : this.keywords) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withKeywords(List<String> keywords) {
        if (keywords != null) {
            this.keywords = new ArrayList<String>();
            for (String item : keywords) {
                this.addToKeywords(item);
            }
        } else {
            this.keywords = null;
        }
        return (A)((Object)this);
    }

    public A withKeywords(String ... keywords) {
        if (this.keywords != null) {
            this.keywords.clear();
            this._visitables.remove((Object)"keywords");
        }
        if (keywords != null) {
            for (String item : keywords) {
                this.addToKeywords(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasKeywords() {
        return this.keywords != null && !this.keywords.isEmpty();
    }

    public A addToLinks(int index, Link item) {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        LinkBuilder builder = new LinkBuilder(item);
        if (index < 0 || index >= this.links.size()) {
            this._visitables.get((Object)"links").add(builder);
            this.links.add(builder);
        } else {
            this._visitables.get((Object)"links").add(index, builder);
            this.links.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToLinks(int index, Link item) {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        LinkBuilder builder = new LinkBuilder(item);
        if (index < 0 || index >= this.links.size()) {
            this._visitables.get((Object)"links").add(builder);
            this.links.add(builder);
        } else {
            this._visitables.get((Object)"links").set(index, builder);
            this.links.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToLinks(Link ... items) {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.get((Object)"links").add(builder);
            this.links.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToLinks(Collection<Link> items) {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.get((Object)"links").add(builder);
            this.links.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromLinks(Link ... items) {
        if (this.links == null) {
            return (A)((Object)this);
        }
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.get((Object)"links").remove((Object)builder);
            this.links.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromLinks(Collection<Link> items) {
        if (this.links == null) {
            return (A)((Object)this);
        }
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.get((Object)"links").remove((Object)builder);
            this.links.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromLinks(Predicate<LinkBuilder> predicate) {
        if (this.links == null) {
            return (A)((Object)this);
        }
        Iterator<LinkBuilder> each = this.links.iterator();
        List visitables = this._visitables.get((Object)"links");
        while (each.hasNext()) {
            LinkBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Link> buildLinks() {
        return this.links != null ? DescriptorFluent.build(this.links) : null;
    }

    public Link buildLink(int index) {
        return this.links.get(index).build();
    }

    public Link buildFirstLink() {
        return this.links.get(0).build();
    }

    public Link buildLastLink() {
        return this.links.get(this.links.size() - 1).build();
    }

    public Link buildMatchingLink(Predicate<LinkBuilder> predicate) {
        for (LinkBuilder item : this.links) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingLink(Predicate<LinkBuilder> predicate) {
        for (LinkBuilder item : this.links) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withLinks(List<Link> links) {
        if (this.links != null) {
            this._visitables.get((Object)"links").clear();
        }
        if (links != null) {
            this.links = new ArrayList();
            for (Link item : links) {
                this.addToLinks(item);
            }
        } else {
            this.links = null;
        }
        return (A)((Object)this);
    }

    public A withLinks(Link ... links) {
        if (this.links != null) {
            this.links.clear();
            this._visitables.remove((Object)"links");
        }
        if (links != null) {
            for (Link item : links) {
                this.addToLinks(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasLinks() {
        return this.links != null && !this.links.isEmpty();
    }

    public A addNewLink(String description, String url) {
        return this.addToLinks(new Link(description, url));
    }

    public LinksNested<A> addNewLink() {
        return new LinksNested(-1, null);
    }

    public LinksNested<A> addNewLinkLike(Link item) {
        return new LinksNested(-1, item);
    }

    public LinksNested<A> setNewLinkLike(int index, Link item) {
        return new LinksNested(index, item);
    }

    public LinksNested<A> editLink(int index) {
        if (this.links.size() <= index) {
            throw new RuntimeException("Can't edit links. Index exceeds size.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    public LinksNested<A> editFirstLink() {
        if (this.links.size() == 0) {
            throw new RuntimeException("Can't edit first links. The list is empty.");
        }
        return this.setNewLinkLike(0, this.buildLink(0));
    }

    public LinksNested<A> editLastLink() {
        int index = this.links.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last links. The list is empty.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    public LinksNested<A> editMatchingLink(Predicate<LinkBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.links.size(); ++i) {
            if (!predicate.test(this.links.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching links. No match found.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    public A addToMaintainers(int index, ContactData item) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        ContactDataBuilder builder = new ContactDataBuilder(item);
        if (index < 0 || index >= this.maintainers.size()) {
            this._visitables.get((Object)"maintainers").add(builder);
            this.maintainers.add(builder);
        } else {
            this._visitables.get((Object)"maintainers").add(index, builder);
            this.maintainers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToMaintainers(int index, ContactData item) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        ContactDataBuilder builder = new ContactDataBuilder(item);
        if (index < 0 || index >= this.maintainers.size()) {
            this._visitables.get((Object)"maintainers").add(builder);
            this.maintainers.add(builder);
        } else {
            this._visitables.get((Object)"maintainers").set(index, builder);
            this.maintainers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToMaintainers(ContactData ... items) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        for (ContactData item : items) {
            ContactDataBuilder builder = new ContactDataBuilder(item);
            this._visitables.get((Object)"maintainers").add(builder);
            this.maintainers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToMaintainers(Collection<ContactData> items) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        for (ContactData item : items) {
            ContactDataBuilder builder = new ContactDataBuilder(item);
            this._visitables.get((Object)"maintainers").add(builder);
            this.maintainers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromMaintainers(ContactData ... items) {
        if (this.maintainers == null) {
            return (A)((Object)this);
        }
        for (ContactData item : items) {
            ContactDataBuilder builder = new ContactDataBuilder(item);
            this._visitables.get((Object)"maintainers").remove((Object)builder);
            this.maintainers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMaintainers(Collection<ContactData> items) {
        if (this.maintainers == null) {
            return (A)((Object)this);
        }
        for (ContactData item : items) {
            ContactDataBuilder builder = new ContactDataBuilder(item);
            this._visitables.get((Object)"maintainers").remove((Object)builder);
            this.maintainers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMaintainers(Predicate<ContactDataBuilder> predicate) {
        if (this.maintainers == null) {
            return (A)((Object)this);
        }
        Iterator<ContactDataBuilder> each = this.maintainers.iterator();
        List visitables = this._visitables.get((Object)"maintainers");
        while (each.hasNext()) {
            ContactDataBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ContactData> buildMaintainers() {
        return this.maintainers != null ? DescriptorFluent.build(this.maintainers) : null;
    }

    public ContactData buildMaintainer(int index) {
        return this.maintainers.get(index).build();
    }

    public ContactData buildFirstMaintainer() {
        return this.maintainers.get(0).build();
    }

    public ContactData buildLastMaintainer() {
        return this.maintainers.get(this.maintainers.size() - 1).build();
    }

    public ContactData buildMatchingMaintainer(Predicate<ContactDataBuilder> predicate) {
        for (ContactDataBuilder item : this.maintainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMaintainer(Predicate<ContactDataBuilder> predicate) {
        for (ContactDataBuilder item : this.maintainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMaintainers(List<ContactData> maintainers) {
        if (this.maintainers != null) {
            this._visitables.get((Object)"maintainers").clear();
        }
        if (maintainers != null) {
            this.maintainers = new ArrayList();
            for (ContactData item : maintainers) {
                this.addToMaintainers(item);
            }
        } else {
            this.maintainers = null;
        }
        return (A)((Object)this);
    }

    public A withMaintainers(ContactData ... maintainers) {
        if (this.maintainers != null) {
            this.maintainers.clear();
            this._visitables.remove((Object)"maintainers");
        }
        if (maintainers != null) {
            for (ContactData item : maintainers) {
                this.addToMaintainers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMaintainers() {
        return this.maintainers != null && !this.maintainers.isEmpty();
    }

    public A addNewMaintainer(String email, String name, String url) {
        return this.addToMaintainers(new ContactData(email, name, url));
    }

    public MaintainersNested<A> addNewMaintainer() {
        return new MaintainersNested(-1, null);
    }

    public MaintainersNested<A> addNewMaintainerLike(ContactData item) {
        return new MaintainersNested(-1, item);
    }

    public MaintainersNested<A> setNewMaintainerLike(int index, ContactData item) {
        return new MaintainersNested(index, item);
    }

    public MaintainersNested<A> editMaintainer(int index) {
        if (this.maintainers.size() <= index) {
            throw new RuntimeException("Can't edit maintainers. Index exceeds size.");
        }
        return this.setNewMaintainerLike(index, this.buildMaintainer(index));
    }

    public MaintainersNested<A> editFirstMaintainer() {
        if (this.maintainers.size() == 0) {
            throw new RuntimeException("Can't edit first maintainers. The list is empty.");
        }
        return this.setNewMaintainerLike(0, this.buildMaintainer(0));
    }

    public MaintainersNested<A> editLastMaintainer() {
        int index = this.maintainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last maintainers. The list is empty.");
        }
        return this.setNewMaintainerLike(index, this.buildMaintainer(index));
    }

    public MaintainersNested<A> editMatchingMaintainer(Predicate<ContactDataBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.maintainers.size(); ++i) {
            if (!predicate.test(this.maintainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching maintainers. No match found.");
        }
        return this.setNewMaintainerLike(index, this.buildMaintainer(index));
    }

    public String getNotes() {
        return this.notes;
    }

    public A withNotes(String notes) {
        this.notes = notes;
        return (A)((Object)this);
    }

    public boolean hasNotes() {
        return this.notes != null;
    }

    public A addToOwners(int index, ContactData item) {
        if (this.owners == null) {
            this.owners = new ArrayList();
        }
        ContactDataBuilder builder = new ContactDataBuilder(item);
        if (index < 0 || index >= this.owners.size()) {
            this._visitables.get((Object)"owners").add(builder);
            this.owners.add(builder);
        } else {
            this._visitables.get((Object)"owners").add(index, builder);
            this.owners.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToOwners(int index, ContactData item) {
        if (this.owners == null) {
            this.owners = new ArrayList();
        }
        ContactDataBuilder builder = new ContactDataBuilder(item);
        if (index < 0 || index >= this.owners.size()) {
            this._visitables.get((Object)"owners").add(builder);
            this.owners.add(builder);
        } else {
            this._visitables.get((Object)"owners").set(index, builder);
            this.owners.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToOwners(ContactData ... items) {
        if (this.owners == null) {
            this.owners = new ArrayList();
        }
        for (ContactData item : items) {
            ContactDataBuilder builder = new ContactDataBuilder(item);
            this._visitables.get((Object)"owners").add(builder);
            this.owners.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToOwners(Collection<ContactData> items) {
        if (this.owners == null) {
            this.owners = new ArrayList();
        }
        for (ContactData item : items) {
            ContactDataBuilder builder = new ContactDataBuilder(item);
            this._visitables.get((Object)"owners").add(builder);
            this.owners.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromOwners(ContactData ... items) {
        if (this.owners == null) {
            return (A)((Object)this);
        }
        for (ContactData item : items) {
            ContactDataBuilder builder = new ContactDataBuilder(item);
            this._visitables.get((Object)"owners").remove((Object)builder);
            this.owners.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOwners(Collection<ContactData> items) {
        if (this.owners == null) {
            return (A)((Object)this);
        }
        for (ContactData item : items) {
            ContactDataBuilder builder = new ContactDataBuilder(item);
            this._visitables.get((Object)"owners").remove((Object)builder);
            this.owners.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromOwners(Predicate<ContactDataBuilder> predicate) {
        if (this.owners == null) {
            return (A)((Object)this);
        }
        Iterator<ContactDataBuilder> each = this.owners.iterator();
        List visitables = this._visitables.get((Object)"owners");
        while (each.hasNext()) {
            ContactDataBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ContactData> buildOwners() {
        return this.owners != null ? DescriptorFluent.build(this.owners) : null;
    }

    public ContactData buildOwner(int index) {
        return this.owners.get(index).build();
    }

    public ContactData buildFirstOwner() {
        return this.owners.get(0).build();
    }

    public ContactData buildLastOwner() {
        return this.owners.get(this.owners.size() - 1).build();
    }

    public ContactData buildMatchingOwner(Predicate<ContactDataBuilder> predicate) {
        for (ContactDataBuilder item : this.owners) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingOwner(Predicate<ContactDataBuilder> predicate) {
        for (ContactDataBuilder item : this.owners) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOwners(List<ContactData> owners) {
        if (this.owners != null) {
            this._visitables.get((Object)"owners").clear();
        }
        if (owners != null) {
            this.owners = new ArrayList();
            for (ContactData item : owners) {
                this.addToOwners(item);
            }
        } else {
            this.owners = null;
        }
        return (A)((Object)this);
    }

    public A withOwners(ContactData ... owners) {
        if (this.owners != null) {
            this.owners.clear();
            this._visitables.remove((Object)"owners");
        }
        if (owners != null) {
            for (ContactData item : owners) {
                this.addToOwners(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOwners() {
        return this.owners != null && !this.owners.isEmpty();
    }

    public A addNewOwner(String email, String name, String url) {
        return this.addToOwners(new ContactData(email, name, url));
    }

    public OwnersNested<A> addNewOwner() {
        return new OwnersNested(-1, null);
    }

    public OwnersNested<A> addNewOwnerLike(ContactData item) {
        return new OwnersNested(-1, item);
    }

    public OwnersNested<A> setNewOwnerLike(int index, ContactData item) {
        return new OwnersNested(index, item);
    }

    public OwnersNested<A> editOwner(int index) {
        if (this.owners.size() <= index) {
            throw new RuntimeException("Can't edit owners. Index exceeds size.");
        }
        return this.setNewOwnerLike(index, this.buildOwner(index));
    }

    public OwnersNested<A> editFirstOwner() {
        if (this.owners.size() == 0) {
            throw new RuntimeException("Can't edit first owners. The list is empty.");
        }
        return this.setNewOwnerLike(0, this.buildOwner(0));
    }

    public OwnersNested<A> editLastOwner() {
        int index = this.owners.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last owners. The list is empty.");
        }
        return this.setNewOwnerLike(index, this.buildOwner(index));
    }

    public OwnersNested<A> editMatchingOwner(Predicate<ContactDataBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.owners.size(); ++i) {
            if (!predicate.test(this.owners.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching owners. No match found.");
        }
        return this.setNewOwnerLike(index, this.buildOwner(index));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DescriptorFluent that = (DescriptorFluent)((Object)o);
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.icons, that.icons)) {
            return false;
        }
        if (!Objects.equals(this.keywords, that.keywords)) {
            return false;
        }
        if (!Objects.equals(this.links, that.links)) {
            return false;
        }
        if (!Objects.equals(this.maintainers, that.maintainers)) {
            return false;
        }
        if (!Objects.equals(this.notes, that.notes)) {
            return false;
        }
        if (!Objects.equals(this.owners, that.owners)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.icons, this.keywords, this.links, this.maintainers, this.notes, this.owners, this.type, this.version, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.icons != null && !this.icons.isEmpty()) {
            sb.append("icons:");
            sb.append(this.icons + ",");
        }
        if (this.keywords != null && !this.keywords.isEmpty()) {
            sb.append("keywords:");
            sb.append(this.keywords + ",");
        }
        if (this.links != null && !this.links.isEmpty()) {
            sb.append("links:");
            sb.append(this.links + ",");
        }
        if (this.maintainers != null && !this.maintainers.isEmpty()) {
            sb.append("maintainers:");
            sb.append(this.maintainers + ",");
        }
        if (this.notes != null) {
            sb.append("notes:");
            sb.append(this.notes + ",");
        }
        if (this.owners != null && !this.owners.isEmpty()) {
            sb.append("owners:");
            sb.append(this.owners + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OwnersNested<N>
    extends ContactDataFluent<OwnersNested<N>>
    implements Nested<N> {
        ContactDataBuilder builder;
        int index;

        OwnersNested(int index, ContactData item) {
            this.index = index;
            this.builder = new ContactDataBuilder(this, item);
        }

        public N and() {
            return (N)DescriptorFluent.this.setToOwners(this.index, this.builder.build());
        }

        public N endOwner() {
            return this.and();
        }
    }

    public class MaintainersNested<N>
    extends ContactDataFluent<MaintainersNested<N>>
    implements Nested<N> {
        ContactDataBuilder builder;
        int index;

        MaintainersNested(int index, ContactData item) {
            this.index = index;
            this.builder = new ContactDataBuilder(this, item);
        }

        public N and() {
            return (N)DescriptorFluent.this.setToMaintainers(this.index, this.builder.build());
        }

        public N endMaintainer() {
            return this.and();
        }
    }

    public class LinksNested<N>
    extends LinkFluent<LinksNested<N>>
    implements Nested<N> {
        LinkBuilder builder;
        int index;

        LinksNested(int index, Link item) {
            this.index = index;
            this.builder = new LinkBuilder(this, item);
        }

        public N and() {
            return (N)DescriptorFluent.this.setToLinks(this.index, this.builder.build());
        }

        public N endLink() {
            return this.and();
        }
    }

    public class IconsNested<N>
    extends ImageSpecFluent<IconsNested<N>>
    implements Nested<N> {
        ImageSpecBuilder builder;
        int index;

        IconsNested(int index, ImageSpec item) {
            this.index = index;
            this.builder = new ImageSpecBuilder(this, item);
        }

        public N and() {
            return (N)DescriptorFluent.this.setToIcons(this.index, this.builder.build());
        }

        public N endIcon() {
            return this.and();
        }
    }
}

