package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SourceFluent<A extends SourceFluent<A>> extends BaseFluent<A>{
  public SourceFluent() {
  }
  
  public SourceFluent(Source instance) {
    this.copyInstance(instance);
  }
  private GitBuilder git;
  private GitHubBuilder github;
  private HelmRepoBuilder helmRepo;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Source instance) {
    instance = (instance != null ? instance : new Source());
    if (instance != null) {
          this.withGit(instance.getGit());
          this.withGithub(instance.getGithub());
          this.withHelmRepo(instance.getHelmRepo());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Git buildGit() {
    return this.git != null ? this.git.build() : null;
  }
  
  public A withGit(Git git) {
    this._visitables.remove("git");
    if (git != null) {
        this.git = new GitBuilder(git);
        this._visitables.get("git").add(this.git);
    } else {
        this.git = null;
        this._visitables.get("git").remove(this.git);
    }
    return (A) this;
  }
  
  public boolean hasGit() {
    return this.git != null;
  }
  
  public GitNested<A> withNewGit() {
    return new GitNested(null);
  }
  
  public GitNested<A> withNewGitLike(Git item) {
    return new GitNested(item);
  }
  
  public GitNested<A> editGit() {
    return withNewGitLike(java.util.Optional.ofNullable(buildGit()).orElse(null));
  }
  
  public GitNested<A> editOrNewGit() {
    return withNewGitLike(java.util.Optional.ofNullable(buildGit()).orElse(new GitBuilder().build()));
  }
  
  public GitNested<A> editOrNewGitLike(Git item) {
    return withNewGitLike(java.util.Optional.ofNullable(buildGit()).orElse(item));
  }
  
  public GitHub buildGithub() {
    return this.github != null ? this.github.build() : null;
  }
  
  public A withGithub(GitHub github) {
    this._visitables.remove("github");
    if (github != null) {
        this.github = new GitHubBuilder(github);
        this._visitables.get("github").add(this.github);
    } else {
        this.github = null;
        this._visitables.get("github").remove(this.github);
    }
    return (A) this;
  }
  
  public boolean hasGithub() {
    return this.github != null;
  }
  
  public GithubNested<A> withNewGithub() {
    return new GithubNested(null);
  }
  
  public GithubNested<A> withNewGithubLike(GitHub item) {
    return new GithubNested(item);
  }
  
  public GithubNested<A> editGithub() {
    return withNewGithubLike(java.util.Optional.ofNullable(buildGithub()).orElse(null));
  }
  
  public GithubNested<A> editOrNewGithub() {
    return withNewGithubLike(java.util.Optional.ofNullable(buildGithub()).orElse(new GitHubBuilder().build()));
  }
  
  public GithubNested<A> editOrNewGithubLike(GitHub item) {
    return withNewGithubLike(java.util.Optional.ofNullable(buildGithub()).orElse(item));
  }
  
  public HelmRepo buildHelmRepo() {
    return this.helmRepo != null ? this.helmRepo.build() : null;
  }
  
  public A withHelmRepo(HelmRepo helmRepo) {
    this._visitables.remove("helmRepo");
    if (helmRepo != null) {
        this.helmRepo = new HelmRepoBuilder(helmRepo);
        this._visitables.get("helmRepo").add(this.helmRepo);
    } else {
        this.helmRepo = null;
        this._visitables.get("helmRepo").remove(this.helmRepo);
    }
    return (A) this;
  }
  
  public boolean hasHelmRepo() {
    return this.helmRepo != null;
  }
  
  public HelmRepoNested<A> withNewHelmRepo() {
    return new HelmRepoNested(null);
  }
  
  public HelmRepoNested<A> withNewHelmRepoLike(HelmRepo item) {
    return new HelmRepoNested(item);
  }
  
  public HelmRepoNested<A> editHelmRepo() {
    return withNewHelmRepoLike(java.util.Optional.ofNullable(buildHelmRepo()).orElse(null));
  }
  
  public HelmRepoNested<A> editOrNewHelmRepo() {
    return withNewHelmRepoLike(java.util.Optional.ofNullable(buildHelmRepo()).orElse(new HelmRepoBuilder().build()));
  }
  
  public HelmRepoNested<A> editOrNewHelmRepoLike(HelmRepo item) {
    return withNewHelmRepoLike(java.util.Optional.ofNullable(buildHelmRepo()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SourceFluent that = (SourceFluent) o;
    if (!java.util.Objects.equals(git, that.git)) return false;
    if (!java.util.Objects.equals(github, that.github)) return false;
    if (!java.util.Objects.equals(helmRepo, that.helmRepo)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(git,  github,  helmRepo,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (git != null) { sb.append("git:"); sb.append(git + ","); }
    if (github != null) { sb.append("github:"); sb.append(github + ","); }
    if (helmRepo != null) { sb.append("helmRepo:"); sb.append(helmRepo + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class GitNested<N> extends GitFluent<GitNested<N>> implements Nested<N>{
    GitNested(Git item) {
      this.builder = new GitBuilder(this, item);
    }
    GitBuilder builder;
    
    public N and() {
      return (N) SourceFluent.this.withGit(builder.build());
    }
    
    public N endGit() {
      return and();
    }
    
  
  }
  public class GithubNested<N> extends GitHubFluent<GithubNested<N>> implements Nested<N>{
    GithubNested(GitHub item) {
      this.builder = new GitHubBuilder(this, item);
    }
    GitHubBuilder builder;
    
    public N and() {
      return (N) SourceFluent.this.withGithub(builder.build());
    }
    
    public N endGithub() {
      return and();
    }
    
  
  }
  public class HelmRepoNested<N> extends HelmRepoFluent<HelmRepoNested<N>> implements Nested<N>{
    HelmRepoNested(HelmRepo item) {
      this.builder = new HelmRepoBuilder(this, item);
    }
    HelmRepoBuilder builder;
    
    public N and() {
      return (N) SourceFluent.this.withHelmRepo(builder.build());
    }
    
    public N endHelmRepo() {
      return and();
    }
    
  
  }

}