package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HelmReleaseRepoFluent<A extends HelmReleaseRepoFluent<A>> extends BaseFluent<A>{
  public HelmReleaseRepoFluent() {
  }
  
  public HelmReleaseRepoFluent(HelmReleaseRepo instance) {
    this.copyInstance(instance);
  }
  private AltSourceBuilder altSource;
  private String chartName;
  private ObjectReferenceBuilder configMapRef;
  private String digest;
  private Boolean insecureSkipVerify;
  private ObjectReferenceBuilder secretRef;
  private SourceBuilder source;
  private String version;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HelmReleaseRepo instance) {
    instance = (instance != null ? instance : new HelmReleaseRepo());
    if (instance != null) {
          this.withAltSource(instance.getAltSource());
          this.withChartName(instance.getChartName());
          this.withConfigMapRef(instance.getConfigMapRef());
          this.withDigest(instance.getDigest());
          this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
          this.withSecretRef(instance.getSecretRef());
          this.withSource(instance.getSource());
          this.withVersion(instance.getVersion());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public AltSource buildAltSource() {
    return this.altSource != null ? this.altSource.build() : null;
  }
  
  public A withAltSource(AltSource altSource) {
    this._visitables.remove("altSource");
    if (altSource != null) {
        this.altSource = new AltSourceBuilder(altSource);
        this._visitables.get("altSource").add(this.altSource);
    } else {
        this.altSource = null;
        this._visitables.get("altSource").remove(this.altSource);
    }
    return (A) this;
  }
  
  public boolean hasAltSource() {
    return this.altSource != null;
  }
  
  public AltSourceNested<A> withNewAltSource() {
    return new AltSourceNested(null);
  }
  
  public AltSourceNested<A> withNewAltSourceLike(AltSource item) {
    return new AltSourceNested(item);
  }
  
  public AltSourceNested<A> editAltSource() {
    return withNewAltSourceLike(java.util.Optional.ofNullable(buildAltSource()).orElse(null));
  }
  
  public AltSourceNested<A> editOrNewAltSource() {
    return withNewAltSourceLike(java.util.Optional.ofNullable(buildAltSource()).orElse(new AltSourceBuilder().build()));
  }
  
  public AltSourceNested<A> editOrNewAltSourceLike(AltSource item) {
    return withNewAltSourceLike(java.util.Optional.ofNullable(buildAltSource()).orElse(item));
  }
  
  public String getChartName() {
    return this.chartName;
  }
  
  public A withChartName(String chartName) {
    this.chartName = chartName;
    return (A) this;
  }
  
  public boolean hasChartName() {
    return this.chartName != null;
  }
  
  public ObjectReference buildConfigMapRef() {
    return this.configMapRef != null ? this.configMapRef.build() : null;
  }
  
  public A withConfigMapRef(ObjectReference configMapRef) {
    this._visitables.remove("configMapRef");
    if (configMapRef != null) {
        this.configMapRef = new ObjectReferenceBuilder(configMapRef);
        this._visitables.get("configMapRef").add(this.configMapRef);
    } else {
        this.configMapRef = null;
        this._visitables.get("configMapRef").remove(this.configMapRef);
    }
    return (A) this;
  }
  
  public boolean hasConfigMapRef() {
    return this.configMapRef != null;
  }
  
  public ConfigMapRefNested<A> withNewConfigMapRef() {
    return new ConfigMapRefNested(null);
  }
  
  public ConfigMapRefNested<A> withNewConfigMapRefLike(ObjectReference item) {
    return new ConfigMapRefNested(item);
  }
  
  public ConfigMapRefNested<A> editConfigMapRef() {
    return withNewConfigMapRefLike(java.util.Optional.ofNullable(buildConfigMapRef()).orElse(null));
  }
  
  public ConfigMapRefNested<A> editOrNewConfigMapRef() {
    return withNewConfigMapRefLike(java.util.Optional.ofNullable(buildConfigMapRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public ConfigMapRefNested<A> editOrNewConfigMapRefLike(ObjectReference item) {
    return withNewConfigMapRefLike(java.util.Optional.ofNullable(buildConfigMapRef()).orElse(item));
  }
  
  public String getDigest() {
    return this.digest;
  }
  
  public A withDigest(String digest) {
    this.digest = digest;
    return (A) this;
  }
  
  public boolean hasDigest() {
    return this.digest != null;
  }
  
  public Boolean getInsecureSkipVerify() {
    return this.insecureSkipVerify;
  }
  
  public A withInsecureSkipVerify(Boolean insecureSkipVerify) {
    this.insecureSkipVerify = insecureSkipVerify;
    return (A) this;
  }
  
  public boolean hasInsecureSkipVerify() {
    return this.insecureSkipVerify != null;
  }
  
  public ObjectReference buildSecretRef() {
    return this.secretRef != null ? this.secretRef.build() : null;
  }
  
  public A withSecretRef(ObjectReference secretRef) {
    this._visitables.remove("secretRef");
    if (secretRef != null) {
        this.secretRef = new ObjectReferenceBuilder(secretRef);
        this._visitables.get("secretRef").add(this.secretRef);
    } else {
        this.secretRef = null;
        this._visitables.get("secretRef").remove(this.secretRef);
    }
    return (A) this;
  }
  
  public boolean hasSecretRef() {
    return this.secretRef != null;
  }
  
  public SecretRefNested<A> withNewSecretRef() {
    return new SecretRefNested(null);
  }
  
  public SecretRefNested<A> withNewSecretRefLike(ObjectReference item) {
    return new SecretRefNested(item);
  }
  
  public SecretRefNested<A> editSecretRef() {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(null));
  }
  
  public SecretRefNested<A> editOrNewSecretRef() {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public SecretRefNested<A> editOrNewSecretRefLike(ObjectReference item) {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(item));
  }
  
  public Source buildSource() {
    return this.source != null ? this.source.build() : null;
  }
  
  public A withSource(Source source) {
    this._visitables.remove("source");
    if (source != null) {
        this.source = new SourceBuilder(source);
        this._visitables.get("source").add(this.source);
    } else {
        this.source = null;
        this._visitables.get("source").remove(this.source);
    }
    return (A) this;
  }
  
  public boolean hasSource() {
    return this.source != null;
  }
  
  public SourceNested<A> withNewSource() {
    return new SourceNested(null);
  }
  
  public SourceNested<A> withNewSourceLike(Source item) {
    return new SourceNested(item);
  }
  
  public SourceNested<A> editSource() {
    return withNewSourceLike(java.util.Optional.ofNullable(buildSource()).orElse(null));
  }
  
  public SourceNested<A> editOrNewSource() {
    return withNewSourceLike(java.util.Optional.ofNullable(buildSource()).orElse(new SourceBuilder().build()));
  }
  
  public SourceNested<A> editOrNewSourceLike(Source item) {
    return withNewSourceLike(java.util.Optional.ofNullable(buildSource()).orElse(item));
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HelmReleaseRepoFluent that = (HelmReleaseRepoFluent) o;
    if (!java.util.Objects.equals(altSource, that.altSource)) return false;
    if (!java.util.Objects.equals(chartName, that.chartName)) return false;
    if (!java.util.Objects.equals(configMapRef, that.configMapRef)) return false;
    if (!java.util.Objects.equals(digest, that.digest)) return false;
    if (!java.util.Objects.equals(insecureSkipVerify, that.insecureSkipVerify)) return false;
    if (!java.util.Objects.equals(secretRef, that.secretRef)) return false;
    if (!java.util.Objects.equals(source, that.source)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(altSource,  chartName,  configMapRef,  digest,  insecureSkipVerify,  secretRef,  source,  version,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (altSource != null) { sb.append("altSource:"); sb.append(altSource + ","); }
    if (chartName != null) { sb.append("chartName:"); sb.append(chartName + ","); }
    if (configMapRef != null) { sb.append("configMapRef:"); sb.append(configMapRef + ","); }
    if (digest != null) { sb.append("digest:"); sb.append(digest + ","); }
    if (insecureSkipVerify != null) { sb.append("insecureSkipVerify:"); sb.append(insecureSkipVerify + ","); }
    if (secretRef != null) { sb.append("secretRef:"); sb.append(secretRef + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withInsecureSkipVerify() {
    return withInsecureSkipVerify(true);
  }
  public class AltSourceNested<N> extends AltSourceFluent<AltSourceNested<N>> implements Nested<N>{
    AltSourceNested(AltSource item) {
      this.builder = new AltSourceBuilder(this, item);
    }
    AltSourceBuilder builder;
    
    public N and() {
      return (N) HelmReleaseRepoFluent.this.withAltSource(builder.build());
    }
    
    public N endAltSource() {
      return and();
    }
    
  
  }
  public class ConfigMapRefNested<N> extends ObjectReferenceFluent<ConfigMapRefNested<N>> implements Nested<N>{
    ConfigMapRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) HelmReleaseRepoFluent.this.withConfigMapRef(builder.build());
    }
    
    public N endConfigMapRef() {
      return and();
    }
    
  
  }
  public class SecretRefNested<N> extends ObjectReferenceFluent<SecretRefNested<N>> implements Nested<N>{
    SecretRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) HelmReleaseRepoFluent.this.withSecretRef(builder.build());
    }
    
    public N endSecretRef() {
      return and();
    }
    
  
  }
  public class SourceNested<N> extends SourceFluent<SourceNested<N>> implements Nested<N>{
    SourceNested(Source item) {
      this.builder = new SourceBuilder(this, item);
    }
    SourceBuilder builder;
    
    public N and() {
      return (N) HelmReleaseRepoFluent.this.withSource(builder.build());
    }
    
    public N endSource() {
      return and();
    }
    
  
  }

}