package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HelmReleaseFluent<A extends HelmReleaseFluent<A>> extends BaseFluent<A>{
  public HelmReleaseFluent() {
  }
  
  public HelmReleaseFluent(HelmRelease instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private HelmReleaseRepoBuilder repo;
  private Map<String,Object> spec;
  private HelmAppStatusBuilder status;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HelmRelease instance) {
    instance = (instance != null ? instance : new HelmRelease());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withKind(instance.getKind());
          this.withMetadata(instance.getMetadata());
          this.withRepo(instance.getRepo());
          this.withSpec(instance.getSpec());
          this.withStatus(instance.getStatus());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public ObjectMeta buildMetadata() {
    return this.metadata != null ? this.metadata.build() : null;
  }
  
  public A withMetadata(ObjectMeta metadata) {
    this._visitables.remove("metadata");
    if (metadata != null) {
        this.metadata = new ObjectMetaBuilder(metadata);
        this._visitables.get("metadata").add(this.metadata);
    } else {
        this.metadata = null;
        this._visitables.get("metadata").remove(this.metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public HelmReleaseRepo buildRepo() {
    return this.repo != null ? this.repo.build() : null;
  }
  
  public A withRepo(HelmReleaseRepo repo) {
    this._visitables.remove("repo");
    if (repo != null) {
        this.repo = new HelmReleaseRepoBuilder(repo);
        this._visitables.get("repo").add(this.repo);
    } else {
        this.repo = null;
        this._visitables.get("repo").remove(this.repo);
    }
    return (A) this;
  }
  
  public boolean hasRepo() {
    return this.repo != null;
  }
  
  public RepoNested<A> withNewRepo() {
    return new RepoNested(null);
  }
  
  public RepoNested<A> withNewRepoLike(HelmReleaseRepo item) {
    return new RepoNested(item);
  }
  
  public RepoNested<A> editRepo() {
    return withNewRepoLike(java.util.Optional.ofNullable(buildRepo()).orElse(null));
  }
  
  public RepoNested<A> editOrNewRepo() {
    return withNewRepoLike(java.util.Optional.ofNullable(buildRepo()).orElse(new HelmReleaseRepoBuilder().build()));
  }
  
  public RepoNested<A> editOrNewRepoLike(HelmReleaseRepo item) {
    return withNewRepoLike(java.util.Optional.ofNullable(buildRepo()).orElse(item));
  }
  
  public A addToSpec(String key,Object value) {
    if(this.spec == null && key != null && value != null) { this.spec = new LinkedHashMap(); }
    if(key != null && value != null) {this.spec.put(key, value);} return (A)this;
  }
  
  public A addToSpec(Map<String,Object> map) {
    if(this.spec == null && map != null) { this.spec = new LinkedHashMap(); }
    if(map != null) { this.spec.putAll(map);} return (A)this;
  }
  
  public A removeFromSpec(String key) {
    if(this.spec == null) { return (A) this; }
    if(key != null && this.spec != null) {this.spec.remove(key);} return (A)this;
  }
  
  public A removeFromSpec(Map<String,Object> map) {
    if(this.spec == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.spec != null){this.spec.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getSpec() {
    return this.spec;
  }
  
  public <K,V>A withSpec(Map<String,Object> spec) {
    if (spec == null) {
      this.spec = null;
    } else {
      this.spec = new LinkedHashMap(spec);
    }
    return (A) this;
  }
  
  public boolean hasSpec() {
    return this.spec != null;
  }
  
  public HelmAppStatus buildStatus() {
    return this.status != null ? this.status.build() : null;
  }
  
  public A withStatus(HelmAppStatus status) {
    this._visitables.remove("status");
    if (status != null) {
        this.status = new HelmAppStatusBuilder(status);
        this._visitables.get("status").add(this.status);
    } else {
        this.status = null;
        this._visitables.get("status").remove(this.status);
    }
    return (A) this;
  }
  
  public boolean hasStatus() {
    return this.status != null;
  }
  
  public StatusNested<A> withNewStatus() {
    return new StatusNested(null);
  }
  
  public StatusNested<A> withNewStatusLike(HelmAppStatus item) {
    return new StatusNested(item);
  }
  
  public StatusNested<A> editStatus() {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(null));
  }
  
  public StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(new HelmAppStatusBuilder().build()));
  }
  
  public StatusNested<A> editOrNewStatusLike(HelmAppStatus item) {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HelmReleaseFluent that = (HelmReleaseFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(repo, that.repo)) return false;
    if (!java.util.Objects.equals(spec, that.spec)) return false;
    if (!java.util.Objects.equals(status, that.status)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  repo,  spec,  status,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (repo != null) { sb.append("repo:"); sb.append(repo + ","); }
    if (spec != null && !spec.isEmpty()) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) HelmReleaseFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }
  public class RepoNested<N> extends HelmReleaseRepoFluent<RepoNested<N>> implements Nested<N>{
    RepoNested(HelmReleaseRepo item) {
      this.builder = new HelmReleaseRepoBuilder(this, item);
    }
    HelmReleaseRepoBuilder builder;
    
    public N and() {
      return (N) HelmReleaseFluent.this.withRepo(builder.build());
    }
    
    public N endRepo() {
      return and();
    }
    
  
  }
  public class StatusNested<N> extends HelmAppStatusFluent<StatusNested<N>> implements Nested<N>{
    StatusNested(HelmAppStatus item) {
      this.builder = new HelmAppStatusBuilder(this, item);
    }
    HelmAppStatusBuilder builder;
    
    public N and() {
      return (N) HelmReleaseFluent.this.withStatus(builder.build());
    }
    
    public N endStatus() {
      return and();
    }
    
  
  }

}