package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DescriptorBuilder extends DescriptorFluent<DescriptorBuilder> implements VisitableBuilder<Descriptor,DescriptorBuilder>{
  public DescriptorBuilder() {
    this(new Descriptor());
  }
  
  public DescriptorBuilder(DescriptorFluent<?> fluent) {
    this(fluent, new Descriptor());
  }
  
  public DescriptorBuilder(DescriptorFluent<?> fluent,Descriptor instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DescriptorBuilder(Descriptor instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DescriptorFluent<?> fluent;
  
  public Descriptor build() {
    Descriptor buildable = new Descriptor(fluent.getDescription(),fluent.buildIcons(),fluent.getKeywords(),fluent.buildLinks(),fluent.buildMaintainers(),fluent.getNotes(),fluent.buildOwners(),fluent.getType(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}