package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.placementrule.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PlacementFluent<A extends PlacementFluent<A>> extends BaseFluent<A>{
  public PlacementFluent() {
  }
  
  public PlacementFluent(Placement instance) {
    this.copyInstance(instance);
  }
  private LabelSelectorBuilder clusterSelector;
  private ArrayList<GenericClusterReferenceBuilder> clusters = new ArrayList<GenericClusterReferenceBuilder>();
  private Boolean local;
  private ObjectReferenceBuilder placementRef;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Placement instance) {
    instance = (instance != null ? instance : new Placement());
    if (instance != null) {
          this.withClusterSelector(instance.getClusterSelector());
          this.withClusters(instance.getClusters());
          this.withLocal(instance.getLocal());
          this.withPlacementRef(instance.getPlacementRef());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public LabelSelector buildClusterSelector() {
    return this.clusterSelector != null ? this.clusterSelector.build() : null;
  }
  
  public A withClusterSelector(LabelSelector clusterSelector) {
    this._visitables.remove("clusterSelector");
    if (clusterSelector != null) {
        this.clusterSelector = new LabelSelectorBuilder(clusterSelector);
        this._visitables.get("clusterSelector").add(this.clusterSelector);
    } else {
        this.clusterSelector = null;
        this._visitables.get("clusterSelector").remove(this.clusterSelector);
    }
    return (A) this;
  }
  
  public boolean hasClusterSelector() {
    return this.clusterSelector != null;
  }
  
  public ClusterSelectorNested<A> withNewClusterSelector() {
    return new ClusterSelectorNested(null);
  }
  
  public ClusterSelectorNested<A> withNewClusterSelectorLike(LabelSelector item) {
    return new ClusterSelectorNested(item);
  }
  
  public ClusterSelectorNested<A> editClusterSelector() {
    return withNewClusterSelectorLike(java.util.Optional.ofNullable(buildClusterSelector()).orElse(null));
  }
  
  public ClusterSelectorNested<A> editOrNewClusterSelector() {
    return withNewClusterSelectorLike(java.util.Optional.ofNullable(buildClusterSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public ClusterSelectorNested<A> editOrNewClusterSelectorLike(LabelSelector item) {
    return withNewClusterSelectorLike(java.util.Optional.ofNullable(buildClusterSelector()).orElse(item));
  }
  
  public A addToClusters(int index,GenericClusterReference item) {
    if (this.clusters == null) {this.clusters = new ArrayList<GenericClusterReferenceBuilder>();}
    GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
    if (index < 0 || index >= clusters.size()) { _visitables.get("clusters").add(builder); clusters.add(builder); } else { _visitables.get("clusters").add(index, builder); clusters.add(index, builder);}
    return (A)this;
  }
  
  public A setToClusters(int index,GenericClusterReference item) {
    if (this.clusters == null) {this.clusters = new ArrayList<GenericClusterReferenceBuilder>();}
    GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
    if (index < 0 || index >= clusters.size()) { _visitables.get("clusters").add(builder); clusters.add(builder); } else { _visitables.get("clusters").set(index, builder); clusters.set(index, builder);}
    return (A)this;
  }
  
  public A addToClusters(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.placementrule.v1.GenericClusterReference... items) {
    if (this.clusters == null) {this.clusters = new ArrayList<GenericClusterReferenceBuilder>();}
    for (GenericClusterReference item : items) {GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);_visitables.get("clusters").add(builder);this.clusters.add(builder);} return (A)this;
  }
  
  public A addAllToClusters(Collection<GenericClusterReference> items) {
    if (this.clusters == null) {this.clusters = new ArrayList<GenericClusterReferenceBuilder>();}
    for (GenericClusterReference item : items) {GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);_visitables.get("clusters").add(builder);this.clusters.add(builder);} return (A)this;
  }
  
  public A removeFromClusters(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.placementrule.v1.GenericClusterReference... items) {
    if (this.clusters == null) return (A)this;
    for (GenericClusterReference item : items) {GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);_visitables.get("clusters").remove(builder); this.clusters.remove(builder);} return (A)this;
  }
  
  public A removeAllFromClusters(Collection<GenericClusterReference> items) {
    if (this.clusters == null) return (A)this;
    for (GenericClusterReference item : items) {GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);_visitables.get("clusters").remove(builder); this.clusters.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromClusters(Predicate<GenericClusterReferenceBuilder> predicate) {
    if (clusters == null) return (A) this;
    final Iterator<GenericClusterReferenceBuilder> each = clusters.iterator();
    final List visitables = _visitables.get("clusters");
    while (each.hasNext()) {
      GenericClusterReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<GenericClusterReference> buildClusters() {
    return this.clusters != null ? build(clusters) : null;
  }
  
  public GenericClusterReference buildCluster(int index) {
    return this.clusters.get(index).build();
  }
  
  public GenericClusterReference buildFirstCluster() {
    return this.clusters.get(0).build();
  }
  
  public GenericClusterReference buildLastCluster() {
    return this.clusters.get(clusters.size() - 1).build();
  }
  
  public GenericClusterReference buildMatchingCluster(Predicate<GenericClusterReferenceBuilder> predicate) {
      for (GenericClusterReferenceBuilder item : clusters) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCluster(Predicate<GenericClusterReferenceBuilder> predicate) {
      for (GenericClusterReferenceBuilder item : clusters) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withClusters(List<GenericClusterReference> clusters) {
    if (this.clusters != null) {
      this._visitables.get("clusters").clear();
    }
    if (clusters != null) {
        this.clusters = new ArrayList();
        for (GenericClusterReference item : clusters) {
          this.addToClusters(item);
        }
    } else {
      this.clusters = null;
    }
    return (A) this;
  }
  
  public A withClusters(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.placementrule.v1.GenericClusterReference... clusters) {
    if (this.clusters != null) {
        this.clusters.clear();
        _visitables.remove("clusters");
    }
    if (clusters != null) {
      for (GenericClusterReference item : clusters) {
        this.addToClusters(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasClusters() {
    return this.clusters != null && !this.clusters.isEmpty();
  }
  
  public A addNewCluster(String name) {
    return (A)addToClusters(new GenericClusterReference(name));
  }
  
  public ClustersNested<A> addNewCluster() {
    return new ClustersNested(-1, null);
  }
  
  public ClustersNested<A> addNewClusterLike(GenericClusterReference item) {
    return new ClustersNested(-1, item);
  }
  
  public ClustersNested<A> setNewClusterLike(int index,GenericClusterReference item) {
    return new ClustersNested(index, item);
  }
  
  public ClustersNested<A> editCluster(int index) {
    if (clusters.size() <= index) throw new RuntimeException("Can't edit clusters. Index exceeds size.");
    return setNewClusterLike(index, buildCluster(index));
  }
  
  public ClustersNested<A> editFirstCluster() {
    if (clusters.size() == 0) throw new RuntimeException("Can't edit first clusters. The list is empty.");
    return setNewClusterLike(0, buildCluster(0));
  }
  
  public ClustersNested<A> editLastCluster() {
    int index = clusters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusters. The list is empty.");
    return setNewClusterLike(index, buildCluster(index));
  }
  
  public ClustersNested<A> editMatchingCluster(Predicate<GenericClusterReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusters.size();i++) { 
    if (predicate.test(clusters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusters. No match found.");
    return setNewClusterLike(index, buildCluster(index));
  }
  
  public Boolean getLocal() {
    return this.local;
  }
  
  public A withLocal(Boolean local) {
    this.local = local;
    return (A) this;
  }
  
  public boolean hasLocal() {
    return this.local != null;
  }
  
  public ObjectReference buildPlacementRef() {
    return this.placementRef != null ? this.placementRef.build() : null;
  }
  
  public A withPlacementRef(ObjectReference placementRef) {
    this._visitables.remove("placementRef");
    if (placementRef != null) {
        this.placementRef = new ObjectReferenceBuilder(placementRef);
        this._visitables.get("placementRef").add(this.placementRef);
    } else {
        this.placementRef = null;
        this._visitables.get("placementRef").remove(this.placementRef);
    }
    return (A) this;
  }
  
  public boolean hasPlacementRef() {
    return this.placementRef != null;
  }
  
  public PlacementRefNested<A> withNewPlacementRef() {
    return new PlacementRefNested(null);
  }
  
  public PlacementRefNested<A> withNewPlacementRefLike(ObjectReference item) {
    return new PlacementRefNested(item);
  }
  
  public PlacementRefNested<A> editPlacementRef() {
    return withNewPlacementRefLike(java.util.Optional.ofNullable(buildPlacementRef()).orElse(null));
  }
  
  public PlacementRefNested<A> editOrNewPlacementRef() {
    return withNewPlacementRefLike(java.util.Optional.ofNullable(buildPlacementRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public PlacementRefNested<A> editOrNewPlacementRefLike(ObjectReference item) {
    return withNewPlacementRefLike(java.util.Optional.ofNullable(buildPlacementRef()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlacementFluent that = (PlacementFluent) o;
    if (!java.util.Objects.equals(clusterSelector, that.clusterSelector)) return false;
    if (!java.util.Objects.equals(clusters, that.clusters)) return false;
    if (!java.util.Objects.equals(local, that.local)) return false;
    if (!java.util.Objects.equals(placementRef, that.placementRef)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clusterSelector,  clusters,  local,  placementRef,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterSelector != null) { sb.append("clusterSelector:"); sb.append(clusterSelector + ","); }
    if (clusters != null && !clusters.isEmpty()) { sb.append("clusters:"); sb.append(clusters + ","); }
    if (local != null) { sb.append("local:"); sb.append(local + ","); }
    if (placementRef != null) { sb.append("placementRef:"); sb.append(placementRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withLocal() {
    return withLocal(true);
  }
  public class ClusterSelectorNested<N> extends LabelSelectorFluent<ClusterSelectorNested<N>> implements Nested<N>{
    ClusterSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) PlacementFluent.this.withClusterSelector(builder.build());
    }
    
    public N endClusterSelector() {
      return and();
    }
    
  
  }
  public class ClustersNested<N> extends GenericClusterReferenceFluent<ClustersNested<N>> implements Nested<N>{
    ClustersNested(int index,GenericClusterReference item) {
      this.index = index;
      this.builder = new GenericClusterReferenceBuilder(this, item);
    }
    GenericClusterReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) PlacementFluent.this.setToClusters(index,builder.build());
    }
    
    public N endCluster() {
      return and();
    }
    
  
  }
  public class PlacementRefNested<N> extends ObjectReferenceFluent<PlacementRefNested<N>> implements Nested<N>{
    PlacementRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) PlacementFluent.this.withPlacementRef(builder.build());
    }
    
    public N endPlacementRef() {
      return and();
    }
    
  
  }

}