package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ApplicationStatusBuilder extends ApplicationStatusFluent<ApplicationStatusBuilder> implements VisitableBuilder<ApplicationStatus,ApplicationStatusBuilder>{
  public ApplicationStatusBuilder() {
    this(new ApplicationStatus());
  }
  
  public ApplicationStatusBuilder(ApplicationStatusFluent<?> fluent) {
    this(fluent, new ApplicationStatus());
  }
  
  public ApplicationStatusBuilder(ApplicationStatusFluent<?> fluent,ApplicationStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ApplicationStatusBuilder(ApplicationStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ApplicationStatusFluent<?> fluent;
  
  public ApplicationStatus build() {
    ApplicationStatus buildable = new ApplicationStatus(fluent.buildComponents(),fluent.getComponentsReady(),fluent.buildConditions(),fluent.getObservedGeneration());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}