package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ObjectStatusBuilder extends ObjectStatusFluent<ObjectStatusBuilder> implements VisitableBuilder<ObjectStatus,ObjectStatusBuilder>{
  public ObjectStatusBuilder() {
    this(new ObjectStatus());
  }
  
  public ObjectStatusBuilder(ObjectStatusFluent<?> fluent) {
    this(fluent, new ObjectStatus());
  }
  
  public ObjectStatusBuilder(ObjectStatusFluent<?> fluent,ObjectStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ObjectStatusBuilder(ObjectStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ObjectStatusFluent<?> fluent;
  
  public ObjectStatus build() {
    ObjectStatus buildable = new ObjectStatus(fluent.getGroup(),fluent.getKind(),fluent.getLink(),fluent.getName(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}