package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GitHubFluent<A extends GitHubFluent<A>> extends BaseFluent<A>{
  public GitHubFluent() {
  }
  
  public GitHubFluent(GitHub instance) {
    this.copyInstance(instance);
  }
  private String branch;
  private String chartPath;
  private List<String> urls = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GitHub instance) {
    instance = (instance != null ? instance : new GitHub());
    if (instance != null) {
          this.withBranch(instance.getBranch());
          this.withChartPath(instance.getChartPath());
          this.withUrls(instance.getUrls());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBranch() {
    return this.branch;
  }
  
  public A withBranch(String branch) {
    this.branch = branch;
    return (A) this;
  }
  
  public boolean hasBranch() {
    return this.branch != null;
  }
  
  public String getChartPath() {
    return this.chartPath;
  }
  
  public A withChartPath(String chartPath) {
    this.chartPath = chartPath;
    return (A) this;
  }
  
  public boolean hasChartPath() {
    return this.chartPath != null;
  }
  
  public A addToUrls(int index,String item) {
    if (this.urls == null) {this.urls = new ArrayList<String>();}
    this.urls.add(index, item);
    return (A)this;
  }
  
  public A setToUrls(int index,String item) {
    if (this.urls == null) {this.urls = new ArrayList<String>();}
    this.urls.set(index, item); return (A)this;
  }
  
  public A addToUrls(java.lang.String... items) {
    if (this.urls == null) {this.urls = new ArrayList<String>();}
    for (String item : items) {this.urls.add(item);} return (A)this;
  }
  
  public A addAllToUrls(Collection<String> items) {
    if (this.urls == null) {this.urls = new ArrayList<String>();}
    for (String item : items) {this.urls.add(item);} return (A)this;
  }
  
  public A removeFromUrls(java.lang.String... items) {
    if (this.urls == null) return (A)this;
    for (String item : items) { this.urls.remove(item);} return (A)this;
  }
  
  public A removeAllFromUrls(Collection<String> items) {
    if (this.urls == null) return (A)this;
    for (String item : items) { this.urls.remove(item);} return (A)this;
  }
  
  public List<String> getUrls() {
    return this.urls;
  }
  
  public String getUrl(int index) {
    return this.urls.get(index);
  }
  
  public String getFirstUrl() {
    return this.urls.get(0);
  }
  
  public String getLastUrl() {
    return this.urls.get(urls.size() - 1);
  }
  
  public String getMatchingUrl(Predicate<String> predicate) {
      for (String item : urls) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingUrl(Predicate<String> predicate) {
      for (String item : urls) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withUrls(List<String> urls) {
    if (urls != null) {
        this.urls = new ArrayList();
        for (String item : urls) {
          this.addToUrls(item);
        }
    } else {
      this.urls = null;
    }
    return (A) this;
  }
  
  public A withUrls(java.lang.String... urls) {
    if (this.urls != null) {
        this.urls.clear();
        _visitables.remove("urls");
    }
    if (urls != null) {
      for (String item : urls) {
        this.addToUrls(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasUrls() {
    return this.urls != null && !this.urls.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GitHubFluent that = (GitHubFluent) o;
    if (!java.util.Objects.equals(branch, that.branch)) return false;
    if (!java.util.Objects.equals(chartPath, that.chartPath)) return false;
    if (!java.util.Objects.equals(urls, that.urls)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(branch,  chartPath,  urls,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (branch != null) { sb.append("branch:"); sb.append(branch + ","); }
    if (chartPath != null) { sb.append("chartPath:"); sb.append(chartPath + ","); }
    if (urls != null && !urls.isEmpty()) { sb.append("urls:"); sb.append(urls + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}