package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubscriptionStatusBuilder extends SubscriptionStatusFluentImpl<SubscriptionStatusBuilder> implements VisitableBuilder<SubscriptionStatus,SubscriptionStatusBuilder>{
  public SubscriptionStatusBuilder() {
    this(false);
  }
  public SubscriptionStatusBuilder(Boolean validationEnabled) {
    this(new SubscriptionStatus(), validationEnabled);
  }
  public SubscriptionStatusBuilder(SubscriptionStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SubscriptionStatusBuilder(SubscriptionStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubscriptionStatus(), validationEnabled);
  }
  public SubscriptionStatusBuilder(SubscriptionStatusFluent<?> fluent,SubscriptionStatus instance) {
    this(fluent, instance, false);
  }
  public SubscriptionStatusBuilder(SubscriptionStatusFluent<?> fluent,SubscriptionStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAnsiblejobs(instance.getAnsiblejobs()); 
    fluent.withLastUpdateTime(instance.getLastUpdateTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withPhase(instance.getPhase()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatuses(instance.getStatuses()); 
    this.validationEnabled = validationEnabled; 
  }
  public SubscriptionStatusBuilder(SubscriptionStatus instance) {
    this(instance,false);
  }
  public SubscriptionStatusBuilder(SubscriptionStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAnsiblejobs(instance.getAnsiblejobs()); 
    this.withLastUpdateTime(instance.getLastUpdateTime()); 
    this.withMessage(instance.getMessage()); 
    this.withPhase(instance.getPhase()); 
    this.withReason(instance.getReason()); 
    this.withStatuses(instance.getStatuses()); 
    this.validationEnabled = validationEnabled; 
  }
  SubscriptionStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SubscriptionStatus build() {
    SubscriptionStatus buildable = new SubscriptionStatus(fluent.getAnsiblejobs(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getPhase(),fluent.getReason(),fluent.getStatuses());
    return buildable;
  }
  
}