package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HelmAppStatusBuilder extends HelmAppStatusFluentImpl<HelmAppStatusBuilder> implements VisitableBuilder<HelmAppStatus,HelmAppStatusBuilder>{
  public HelmAppStatusBuilder() {
    this(false);
  }
  public HelmAppStatusBuilder(Boolean validationEnabled) {
    this(new HelmAppStatus(), validationEnabled);
  }
  public HelmAppStatusBuilder(HelmAppStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public HelmAppStatusBuilder(HelmAppStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HelmAppStatus(), validationEnabled);
  }
  public HelmAppStatusBuilder(HelmAppStatusFluent<?> fluent,HelmAppStatus instance) {
    this(fluent, instance, false);
  }
  public HelmAppStatusBuilder(HelmAppStatusFluent<?> fluent,HelmAppStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withDeployedRelease(instance.getDeployedRelease()); 
    this.validationEnabled = validationEnabled; 
  }
  public HelmAppStatusBuilder(HelmAppStatus instance) {
    this(instance,false);
  }
  public HelmAppStatusBuilder(HelmAppStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withDeployedRelease(instance.getDeployedRelease()); 
    this.validationEnabled = validationEnabled; 
  }
  HelmAppStatusFluent<?> fluent;
  Boolean validationEnabled;
  public HelmAppStatus build() {
    HelmAppStatus buildable = new HelmAppStatus(fluent.getConditions(),fluent.getDeployedRelease());
    return buildable;
  }
  
}