package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HelmAppConditionBuilder extends HelmAppConditionFluentImpl<HelmAppConditionBuilder> implements VisitableBuilder<HelmAppCondition,HelmAppConditionBuilder>{
  public HelmAppConditionBuilder() {
    this(false);
  }
  public HelmAppConditionBuilder(Boolean validationEnabled) {
    this(new HelmAppCondition(), validationEnabled);
  }
  public HelmAppConditionBuilder(HelmAppConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public HelmAppConditionBuilder(HelmAppConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HelmAppCondition(), validationEnabled);
  }
  public HelmAppConditionBuilder(HelmAppConditionFluent<?> fluent,HelmAppCondition instance) {
    this(fluent, instance, false);
  }
  public HelmAppConditionBuilder(HelmAppConditionFluent<?> fluent,HelmAppCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  public HelmAppConditionBuilder(HelmAppCondition instance) {
    this(instance,false);
  }
  public HelmAppConditionBuilder(HelmAppCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  HelmAppConditionFluent<?> fluent;
  Boolean validationEnabled;
  public HelmAppCondition build() {
    HelmAppCondition buildable = new HelmAppCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}