package io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ChannelSpecFluentImpl<A extends ChannelSpecFluent<A>> extends BaseFluent<A> implements ChannelSpecFluent<A>{
  public ChannelSpecFluentImpl() {
  }
  public ChannelSpecFluentImpl(ChannelSpec instance) {
    this.withConfigMapRef(instance.getConfigMapRef()); 
    this.withGates(instance.getGates()); 
    this.withInsecureSkipVerify(instance.getInsecureSkipVerify()); 
    this.withPathname(instance.getPathname()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withSourceNamespaces(instance.getSourceNamespaces()); 
    this.withType(instance.getType()); 
  }
  private ObjectReferenceBuilder configMapRef;
  private ChannelGateBuilder gates;
  private Boolean insecureSkipVerify;
  private String pathname;
  private ObjectReferenceBuilder secretRef;
  private List<String> sourceNamespaces = new ArrayList<String>();
  private String type;
  
  /**
   * This method has been deprecated, please use method buildConfigMapRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getConfigMapRef() {
    return this.configMapRef!=null ?this.configMapRef.build():null;
  }
  public ObjectReference buildConfigMapRef() {
    return this.configMapRef!=null ?this.configMapRef.build():null;
  }
  public A withConfigMapRef(ObjectReference configMapRef) {
    _visitables.get("configMapRef").remove(this.configMapRef);
    if (configMapRef!=null){ this.configMapRef= new ObjectReferenceBuilder(configMapRef); _visitables.get("configMapRef").add(this.configMapRef);} else { this.configMapRef = null; _visitables.get("configMapRef").remove(this.configMapRef); } return (A) this;
  }
  public Boolean hasConfigMapRef() {
    return this.configMapRef != null;
  }
  public ChannelSpecFluent.ConfigMapRefNested<A> withNewConfigMapRef() {
    return new ChannelSpecFluentImpl.ConfigMapRefNestedImpl();
  }
  public ChannelSpecFluent.ConfigMapRefNested<A> withNewConfigMapRefLike(ObjectReference item) {
    return new ChannelSpecFluentImpl.ConfigMapRefNestedImpl(item);
  }
  public ChannelSpecFluent.ConfigMapRefNested<A> editConfigMapRef() {
    return withNewConfigMapRefLike(getConfigMapRef());
  }
  public ChannelSpecFluent.ConfigMapRefNested<A> editOrNewConfigMapRef() {
    return withNewConfigMapRefLike(getConfigMapRef() != null ? getConfigMapRef(): new ObjectReferenceBuilder().build());
  }
  public ChannelSpecFluent.ConfigMapRefNested<A> editOrNewConfigMapRefLike(ObjectReference item) {
    return withNewConfigMapRefLike(getConfigMapRef() != null ? getConfigMapRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGates instead.
   * @return The buildable object.
   */
  @Deprecated
  public ChannelGate getGates() {
    return this.gates!=null ?this.gates.build():null;
  }
  public ChannelGate buildGates() {
    return this.gates!=null ?this.gates.build():null;
  }
  public A withGates(ChannelGate gates) {
    _visitables.get("gates").remove(this.gates);
    if (gates!=null){ this.gates= new ChannelGateBuilder(gates); _visitables.get("gates").add(this.gates);} else { this.gates = null; _visitables.get("gates").remove(this.gates); } return (A) this;
  }
  public Boolean hasGates() {
    return this.gates != null;
  }
  public ChannelSpecFluent.GatesNested<A> withNewGates() {
    return new ChannelSpecFluentImpl.GatesNestedImpl();
  }
  public ChannelSpecFluent.GatesNested<A> withNewGatesLike(ChannelGate item) {
    return new ChannelSpecFluentImpl.GatesNestedImpl(item);
  }
  public ChannelSpecFluent.GatesNested<A> editGates() {
    return withNewGatesLike(getGates());
  }
  public ChannelSpecFluent.GatesNested<A> editOrNewGates() {
    return withNewGatesLike(getGates() != null ? getGates(): new ChannelGateBuilder().build());
  }
  public ChannelSpecFluent.GatesNested<A> editOrNewGatesLike(ChannelGate item) {
    return withNewGatesLike(getGates() != null ? getGates(): item);
  }
  public Boolean getInsecureSkipVerify() {
    return this.insecureSkipVerify;
  }
  public A withInsecureSkipVerify(Boolean insecureSkipVerify) {
    this.insecureSkipVerify=insecureSkipVerify; return (A) this;
  }
  public Boolean hasInsecureSkipVerify() {
    return this.insecureSkipVerify != null;
  }
  public String getPathname() {
    return this.pathname;
  }
  public A withPathname(String pathname) {
    this.pathname=pathname; return (A) this;
  }
  public Boolean hasPathname() {
    return this.pathname != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public ObjectReference buildSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public A withSecretRef(ObjectReference secretRef) {
    _visitables.get("secretRef").remove(this.secretRef);
    if (secretRef!=null){ this.secretRef= new ObjectReferenceBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} else { this.secretRef = null; _visitables.get("secretRef").remove(this.secretRef); } return (A) this;
  }
  public Boolean hasSecretRef() {
    return this.secretRef != null;
  }
  public ChannelSpecFluent.SecretRefNested<A> withNewSecretRef() {
    return new ChannelSpecFluentImpl.SecretRefNestedImpl();
  }
  public ChannelSpecFluent.SecretRefNested<A> withNewSecretRefLike(ObjectReference item) {
    return new ChannelSpecFluentImpl.SecretRefNestedImpl(item);
  }
  public ChannelSpecFluent.SecretRefNested<A> editSecretRef() {
    return withNewSecretRefLike(getSecretRef());
  }
  public ChannelSpecFluent.SecretRefNested<A> editOrNewSecretRef() {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new ObjectReferenceBuilder().build());
  }
  public ChannelSpecFluent.SecretRefNested<A> editOrNewSecretRefLike(ObjectReference item) {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
  }
  public A addToSourceNamespaces(Integer index,String item) {
    if (this.sourceNamespaces == null) {this.sourceNamespaces = new ArrayList<String>();}
    this.sourceNamespaces.add(index, item);
    return (A)this;
  }
  public A setToSourceNamespaces(Integer index,String item) {
    if (this.sourceNamespaces == null) {this.sourceNamespaces = new ArrayList<String>();}
    this.sourceNamespaces.set(index, item); return (A)this;
  }
  public A addToSourceNamespaces(java.lang.String... items) {
    if (this.sourceNamespaces == null) {this.sourceNamespaces = new ArrayList<String>();}
    for (String item : items) {this.sourceNamespaces.add(item);} return (A)this;
  }
  public A addAllToSourceNamespaces(Collection<String> items) {
    if (this.sourceNamespaces == null) {this.sourceNamespaces = new ArrayList<String>();}
    for (String item : items) {this.sourceNamespaces.add(item);} return (A)this;
  }
  public A removeFromSourceNamespaces(java.lang.String... items) {
    for (String item : items) {if (this.sourceNamespaces!= null){ this.sourceNamespaces.remove(item);}} return (A)this;
  }
  public A removeAllFromSourceNamespaces(Collection<String> items) {
    for (String item : items) {if (this.sourceNamespaces!= null){ this.sourceNamespaces.remove(item);}} return (A)this;
  }
  public List<String> getSourceNamespaces() {
    return this.sourceNamespaces;
  }
  public String getSourceNamespace(Integer index) {
    return this.sourceNamespaces.get(index);
  }
  public String getFirstSourceNamespace() {
    return this.sourceNamespaces.get(0);
  }
  public String getLastSourceNamespace() {
    return this.sourceNamespaces.get(sourceNamespaces.size() - 1);
  }
  public String getMatchingSourceNamespace(Predicate<String> predicate) {
    for (String item: sourceNamespaces) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingSourceNamespace(Predicate<String> predicate) {
    for (String item: sourceNamespaces) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSourceNamespaces(List<String> sourceNamespaces) {
    if (sourceNamespaces != null) {this.sourceNamespaces = new ArrayList(); for (String item : sourceNamespaces){this.addToSourceNamespaces(item);}} else { this.sourceNamespaces = null;} return (A) this;
  }
  public A withSourceNamespaces(java.lang.String... sourceNamespaces) {
    if (this.sourceNamespaces != null) {this.sourceNamespaces.clear();}
    if (sourceNamespaces != null) {for (String item :sourceNamespaces){ this.addToSourceNamespaces(item);}} return (A) this;
  }
  public Boolean hasSourceNamespaces() {
    return sourceNamespaces != null && !sourceNamespaces.isEmpty();
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChannelSpecFluentImpl that = (ChannelSpecFluentImpl) o;
    if (configMapRef != null ? !configMapRef.equals(that.configMapRef) :that.configMapRef != null) return false;
    if (gates != null ? !gates.equals(that.gates) :that.gates != null) return false;
    if (insecureSkipVerify != null ? !insecureSkipVerify.equals(that.insecureSkipVerify) :that.insecureSkipVerify != null) return false;
    if (pathname != null ? !pathname.equals(that.pathname) :that.pathname != null) return false;
    if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
    if (sourceNamespaces != null ? !sourceNamespaces.equals(that.sourceNamespaces) :that.sourceNamespaces != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(configMapRef,  gates,  insecureSkipVerify,  pathname,  secretRef,  sourceNamespaces,  type,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configMapRef != null) { sb.append("configMapRef:"); sb.append(configMapRef + ","); }
    if (gates != null) { sb.append("gates:"); sb.append(gates + ","); }
    if (insecureSkipVerify != null) { sb.append("insecureSkipVerify:"); sb.append(insecureSkipVerify + ","); }
    if (pathname != null) { sb.append("pathname:"); sb.append(pathname + ","); }
    if (secretRef != null) { sb.append("secretRef:"); sb.append(secretRef + ","); }
    if (sourceNamespaces != null && !sourceNamespaces.isEmpty()) { sb.append("sourceNamespaces:"); sb.append(sourceNamespaces + ","); }
    if (type != null) { sb.append("type:"); sb.append(type); }
    sb.append("}");
    return sb.toString();
  }
  public A withInsecureSkipVerify() {
    return withInsecureSkipVerify(true);
  }
  class ConfigMapRefNestedImpl<N> extends ObjectReferenceFluentImpl<ChannelSpecFluent.ConfigMapRefNested<N>> implements ChannelSpecFluent.ConfigMapRefNested<N>,Nested<N>{
    ConfigMapRefNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ConfigMapRefNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) ChannelSpecFluentImpl.this.withConfigMapRef(builder.build());
    }
    public N endConfigMapRef() {
      return and();
    }
    
  }
  class GatesNestedImpl<N> extends ChannelGateFluentImpl<ChannelSpecFluent.GatesNested<N>> implements ChannelSpecFluent.GatesNested<N>,Nested<N>{
    GatesNestedImpl(ChannelGate item) {
      this.builder = new ChannelGateBuilder(this, item);
    }
    GatesNestedImpl() {
      this.builder = new ChannelGateBuilder(this);
    }
    ChannelGateBuilder builder;
    public N and() {
      return (N) ChannelSpecFluentImpl.this.withGates(builder.build());
    }
    public N endGates() {
      return and();
    }
    
  }
  class SecretRefNestedImpl<N> extends ObjectReferenceFluentImpl<ChannelSpecFluent.SecretRefNested<N>> implements ChannelSpecFluent.SecretRefNested<N>,Nested<N>{
    SecretRefNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    SecretRefNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) ChannelSpecFluentImpl.this.withSecretRef(builder.build());
    }
    public N endSecretRef() {
      return and();
    }
    
  }
  
}