package io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ChannelFluentImpl<A extends ChannelFluent<A>> extends BaseFluent<A> implements ChannelFluent<A>{
  public ChannelFluentImpl() {
  }
  public ChannelFluentImpl(Channel instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ChannelSpecBuilder spec;
  private ChannelStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ChannelFluent.MetadataNested<A> withNewMetadata() {
    return new ChannelFluentImpl.MetadataNestedImpl();
  }
  public ChannelFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ChannelFluentImpl.MetadataNestedImpl(item);
  }
  public ChannelFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ChannelFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ChannelFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ChannelSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public ChannelSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(ChannelSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new ChannelSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public ChannelFluent.SpecNested<A> withNewSpec() {
    return new ChannelFluentImpl.SpecNestedImpl();
  }
  public ChannelFluent.SpecNested<A> withNewSpecLike(ChannelSpec item) {
    return new ChannelFluentImpl.SpecNestedImpl(item);
  }
  public ChannelFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public ChannelFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new ChannelSpecBuilder().build());
  }
  public ChannelFluent.SpecNested<A> editOrNewSpecLike(ChannelSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ChannelStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public ChannelStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(ChannelStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new ChannelStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public ChannelFluent.StatusNested<A> withNewStatus() {
    return new ChannelFluentImpl.StatusNestedImpl();
  }
  public ChannelFluent.StatusNested<A> withNewStatusLike(ChannelStatus item) {
    return new ChannelFluentImpl.StatusNestedImpl(item);
  }
  public ChannelFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public ChannelFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new ChannelStatusBuilder().build());
  }
  public ChannelFluent.StatusNested<A> editOrNewStatusLike(ChannelStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChannelFluentImpl that = (ChannelFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ChannelFluent.MetadataNested<N>> implements ChannelFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ChannelFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends ChannelSpecFluentImpl<ChannelFluent.SpecNested<N>> implements ChannelFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(ChannelSpec item) {
      this.builder = new ChannelSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new ChannelSpecBuilder(this);
    }
    ChannelSpecBuilder builder;
    public N and() {
      return (N) ChannelFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends ChannelStatusFluentImpl<ChannelFluent.StatusNested<N>> implements ChannelFluent.StatusNested<N>,Nested<N>{
    StatusNestedImpl(ChannelStatus item) {
      this.builder = new ChannelStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new ChannelStatusBuilder(this);
    }
    ChannelStatusBuilder builder;
    public N and() {
      return (N) ChannelFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}